/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.managementdashboard.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetManagementDashboardRequest
extends BmcRequest<Void> {
    private String managementDashboardId;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"managementDashboardId", "opcRetryToken", "opcRequestId"})
    GetManagementDashboardRequest(String managementDashboardId, String opcRetryToken, String opcRequestId) {
        this.managementDashboardId = managementDashboardId;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagementDashboardId() {
        return this.managementDashboardId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetManagementDashboardRequest, Void> {
        private String managementDashboardId;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagementDashboardRequest o) {
            this.managementDashboardId(o.getManagementDashboardId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagementDashboardRequest build() {
            GetManagementDashboardRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managementDashboardId(String managementDashboardId) {
            this.managementDashboardId = managementDashboardId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetManagementDashboardRequest buildWithoutInvocationCallback() {
            return new GetManagementDashboardRequest(this.managementDashboardId, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "GetManagementDashboardRequest.Builder(managementDashboardId=" + this.managementDashboardId + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

