/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.marketplace.model.ListingSummary;
import com.oracle.bmc.marketplace.requests.ListListingsRequest;
import com.oracle.bmc.marketplace.responses.ListListingsResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListListingsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListListingsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListListingsRequest interceptRequest(ListListingsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListListingsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181001").path("listings");
        if (request.getName() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"name", request.getName(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getListingId() != null) {
            target = target.queryParam("listingId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getListingId())});
        }
        if (request.getPublisherId() != null) {
            target = target.queryParam("publisherId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPublisherId())});
        }
        if (request.getPackageType() != null) {
            target = target.queryParam("packageType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPackageType())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getCategory() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"category", request.getCategory(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getPricing() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"pricing", request.getPricing(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getIsFeatured() != null) {
            target = target.queryParam("isFeatured", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsFeatured())});
        }
        if (request.getListingTypes() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"listingTypes", request.getListingTypes(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getOperatingSystems() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"operatingSystems", request.getOperatingSystems(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListListingsResponse> fromResponse() {
        Function<Response, ListListingsResponse> transformer = new Function<Response, ListListingsResponse>(){

            public ListListingsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.marketplace.responses.ListListingsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<ListingSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListListingsResponse.Builder builder = ListListingsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.items((List)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListListingsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

