/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetAcceptedAgreementRequest
extends BmcRequest<Void> {
    private String acceptedAgreementId;
    private String opcRequestId;

    @ConstructorProperties(value={"acceptedAgreementId", "opcRequestId"})
    GetAcceptedAgreementRequest(String acceptedAgreementId, String opcRequestId) {
        this.acceptedAgreementId = acceptedAgreementId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAcceptedAgreementId() {
        return this.acceptedAgreementId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAcceptedAgreementRequest, Void> {
        private String acceptedAgreementId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAcceptedAgreementRequest o) {
            this.acceptedAgreementId(o.getAcceptedAgreementId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAcceptedAgreementRequest build() {
            GetAcceptedAgreementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder acceptedAgreementId(String acceptedAgreementId) {
            this.acceptedAgreementId = acceptedAgreementId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetAcceptedAgreementRequest buildWithoutInvocationCallback() {
            return new GetAcceptedAgreementRequest(this.acceptedAgreementId, this.opcRequestId);
        }

        public String toString() {
            return "GetAcceptedAgreementRequest.Builder(acceptedAgreementId=" + this.acceptedAgreementId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

