/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPublicationPackageRequest
extends BmcRequest<Void> {
    private String publicationId;
    private String packageVersion;
    private String opcRequestId;

    @ConstructorProperties(value={"publicationId", "packageVersion", "opcRequestId"})
    GetPublicationPackageRequest(String publicationId, String packageVersion, String opcRequestId) {
        this.publicationId = publicationId;
        this.packageVersion = packageVersion;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPublicationId() {
        return this.publicationId;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPublicationPackageRequest, Void> {
        private String publicationId;
        private String packageVersion;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPublicationPackageRequest o) {
            this.publicationId(o.getPublicationId());
            this.packageVersion(o.getPackageVersion());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPublicationPackageRequest build() {
            GetPublicationPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder publicationId(String publicationId) {
            this.publicationId = publicationId;
            return this;
        }

        public Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetPublicationPackageRequest buildWithoutInvocationCallback() {
            return new GetPublicationPackageRequest(this.publicationId, this.packageVersion, this.opcRequestId);
        }

        public String toString() {
            return "GetPublicationPackageRequest.Builder(publicationId=" + this.publicationId + ", packageVersion=" + this.packageVersion + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

