/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListAgreementsRequest
extends BmcRequest<Void> {
    private String listingId;
    private String packageVersion;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private String compartmentId;

    @ConstructorProperties(value={"listingId", "packageVersion", "opcRequestId", "limit", "page", "compartmentId"})
    ListAgreementsRequest(String listingId, String packageVersion, String opcRequestId, Integer limit, String page, String compartmentId) {
        this.listingId = listingId;
        this.packageVersion = packageVersion;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAgreementsRequest, Void> {
        private String listingId;
        private String packageVersion;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAgreementsRequest o) {
            this.listingId(o.getListingId());
            this.packageVersion(o.getPackageVersion());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAgreementsRequest build() {
            ListAgreementsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public ListAgreementsRequest buildWithoutInvocationCallback() {
            return new ListAgreementsRequest(this.listingId, this.packageVersion, this.opcRequestId, this.limit, this.page, this.compartmentId);
        }

        public String toString() {
            return "ListAgreementsRequest.Builder(listingId=" + this.listingId + ", packageVersion=" + this.packageVersion + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

