/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.marketplace.model.ListingType;
import com.oracle.bmc.marketplace.model.PricingTypeEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListListingsRequest
extends BmcRequest<Void> {
    private List<String> name;
    private String listingId;
    private String publisherId;
    private String packageType;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private List<String> category;
    private List<PricingTypeEnum> pricing;
    private Boolean isFeatured;
    private List<ListingType> listingTypes;
    private List<String> operatingSystems;
    private String compartmentId;

    @ConstructorProperties(value={"name", "listingId", "publisherId", "packageType", "opcRequestId", "limit", "page", "sortBy", "sortOrder", "category", "pricing", "isFeatured", "listingTypes", "operatingSystems", "compartmentId"})
    ListListingsRequest(List<String> name, String listingId, String publisherId, String packageType, String opcRequestId, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, List<String> category, List<PricingTypeEnum> pricing, Boolean isFeatured, List<ListingType> listingTypes, List<String> operatingSystems, String compartmentId) {
        this.name = name;
        this.listingId = listingId;
        this.publisherId = publisherId;
        this.packageType = packageType;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.category = category;
        this.pricing = pricing;
        this.isFeatured = isFeatured;
        this.listingTypes = listingTypes;
        this.operatingSystems = operatingSystems;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getName() {
        return this.name;
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getPublisherId() {
        return this.publisherId;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public List<String> getCategory() {
        return this.category;
    }

    public List<PricingTypeEnum> getPricing() {
        return this.pricing;
    }

    public Boolean getIsFeatured() {
        return this.isFeatured;
    }

    public List<ListingType> getListingTypes() {
        return this.listingTypes;
    }

    public List<String> getOperatingSystems() {
        return this.operatingSystems;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListListingsRequest, Void> {
        private List<String> name;
        private String listingId;
        private String publisherId;
        private String packageType;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private List<String> category;
        private List<PricingTypeEnum> pricing;
        private Boolean isFeatured;
        private List<ListingType> listingTypes;
        private List<String> operatingSystems;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListListingsRequest o) {
            this.name(o.getName());
            this.listingId(o.getListingId());
            this.publisherId(o.getPublisherId());
            this.packageType(o.getPackageType());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.category(o.getCategory());
            this.pricing(o.getPricing());
            this.isFeatured(o.getIsFeatured());
            this.listingTypes(o.getListingTypes());
            this.operatingSystems(o.getOperatingSystems());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListListingsRequest build() {
            ListListingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder name(List<String> name) {
            this.name = name;
            return this;
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder category(List<String> category) {
            this.category = category;
            return this;
        }

        public Builder pricing(List<PricingTypeEnum> pricing) {
            this.pricing = pricing;
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            return this;
        }

        public Builder listingTypes(List<ListingType> listingTypes) {
            this.listingTypes = listingTypes;
            return this;
        }

        public Builder operatingSystems(List<String> operatingSystems) {
            this.operatingSystems = operatingSystems;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public ListListingsRequest buildWithoutInvocationCallback() {
            return new ListListingsRequest(this.name, this.listingId, this.publisherId, this.packageType, this.opcRequestId, this.limit, this.page, this.sortBy, this.sortOrder, this.category, this.pricing, this.isFeatured, this.listingTypes, this.operatingSystems, this.compartmentId);
        }

        public String toString() {
            return "ListListingsRequest.Builder(name=" + this.name + ", listingId=" + this.listingId + ", publisherId=" + this.publisherId + ", packageType=" + this.packageType + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", category=" + this.category + ", pricing=" + this.pricing + ", isFeatured=" + this.isFeatured + ", listingTypes=" + this.listingTypes + ", operatingSystems=" + this.operatingSystems + ", compartmentId=" + this.compartmentId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timereleased("TIMERELEASED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

