/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.marketplace.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.ws.rs.client.Invocation;

public class ListReportsRequest
extends BmcRequest<Void> {
    private String reportType;
    private Date date;
    private String compartmentId;
    private String opcRequestId;
    private String page;

    @ConstructorProperties(value={"reportType", "date", "compartmentId", "opcRequestId", "page"})
    ListReportsRequest(String reportType, Date date, String compartmentId, String opcRequestId, String page) {
        this.reportType = reportType;
        this.date = date;
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getReportType() {
        return this.reportType;
    }

    public Date getDate() {
        return this.date;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListReportsRequest, Void> {
        private String reportType;
        private Date date;
        private String compartmentId;
        private String opcRequestId;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListReportsRequest o) {
            this.reportType(o.getReportType());
            this.date(o.getDate());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListReportsRequest build() {
            ListReportsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        public Builder date(Date date) {
            this.date = date;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListReportsRequest buildWithoutInvocationCallback() {
            return new ListReportsRequest(this.reportType, this.date, this.compartmentId, this.opcRequestId, this.page);
        }

        public String toString() {
            return "ListReportsRequest.Builder(reportType=" + this.reportType + ", date=" + this.date + ", compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ")";
        }
    }
}

