/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.monitoring.MonitoringAsync;
import com.oracle.bmc.monitoring.internal.http.ChangeAlarmCompartmentConverter;
import com.oracle.bmc.monitoring.internal.http.CreateAlarmConverter;
import com.oracle.bmc.monitoring.internal.http.DeleteAlarmConverter;
import com.oracle.bmc.monitoring.internal.http.GetAlarmConverter;
import com.oracle.bmc.monitoring.internal.http.GetAlarmHistoryConverter;
import com.oracle.bmc.monitoring.internal.http.ListAlarmsConverter;
import com.oracle.bmc.monitoring.internal.http.ListAlarmsStatusConverter;
import com.oracle.bmc.monitoring.internal.http.ListMetricsConverter;
import com.oracle.bmc.monitoring.internal.http.PostMetricDataConverter;
import com.oracle.bmc.monitoring.internal.http.RemoveAlarmSuppressionConverter;
import com.oracle.bmc.monitoring.internal.http.SummarizeMetricsDataConverter;
import com.oracle.bmc.monitoring.internal.http.UpdateAlarmConverter;
import com.oracle.bmc.monitoring.requests.ChangeAlarmCompartmentRequest;
import com.oracle.bmc.monitoring.requests.CreateAlarmRequest;
import com.oracle.bmc.monitoring.requests.DeleteAlarmRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmHistoryRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsStatusRequest;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import com.oracle.bmc.monitoring.requests.RemoveAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.requests.SummarizeMetricsDataRequest;
import com.oracle.bmc.monitoring.requests.UpdateAlarmRequest;
import com.oracle.bmc.monitoring.responses.ChangeAlarmCompartmentResponse;
import com.oracle.bmc.monitoring.responses.CreateAlarmResponse;
import com.oracle.bmc.monitoring.responses.DeleteAlarmResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmHistoryResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsStatusResponse;
import com.oracle.bmc.monitoring.responses.ListMetricsResponse;
import com.oracle.bmc.monitoring.responses.PostMetricDataResponse;
import com.oracle.bmc.monitoring.responses.RemoveAlarmSuppressionResponse;
import com.oracle.bmc.monitoring.responses.SummarizeMetricsDataResponse;
import com.oracle.bmc.monitoring.responses.UpdateAlarmResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringAsyncClient
implements MonitoringAsync {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoringAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MONITORING").serviceEndpointPrefix("telemetry").serviceEndpointTemplate("https://telemetry.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public MonitoringAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public MonitoringAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public MonitoringAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public MonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public MonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public MonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public MonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public MonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeAlarmCompartmentResponse> changeAlarmCompartment(ChangeAlarmCompartmentRequest request, AsyncHandler<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse> handler) {
        LOG.trace("Called async changeAlarmCompartment");
        ChangeAlarmCompartmentRequest interceptedRequest = ChangeAlarmCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAlarmCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAlarmCompartmentResponse> transformer = ChangeAlarmCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateAlarmResponse> createAlarm(CreateAlarmRequest request, AsyncHandler<CreateAlarmRequest, CreateAlarmResponse> handler) {
        LOG.trace("Called async createAlarm");
        CreateAlarmRequest interceptedRequest = CreateAlarmConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAlarmConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAlarmResponse> transformer = CreateAlarmConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAlarmRequest, CreateAlarmResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAlarmRequest, CreateAlarmResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAlarmResponse> deleteAlarm(DeleteAlarmRequest request, AsyncHandler<DeleteAlarmRequest, DeleteAlarmResponse> handler) {
        LOG.trace("Called async deleteAlarm");
        DeleteAlarmRequest interceptedRequest = DeleteAlarmConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAlarmConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAlarmResponse> transformer = DeleteAlarmConverter.fromResponse();
        AsyncHandler<DeleteAlarmRequest, DeleteAlarmResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAlarmRequest, DeleteAlarmResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAlarmResponse> getAlarm(GetAlarmRequest request, AsyncHandler<GetAlarmRequest, GetAlarmResponse> handler) {
        LOG.trace("Called async getAlarm");
        GetAlarmRequest interceptedRequest = GetAlarmConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAlarmConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAlarmResponse> transformer = GetAlarmConverter.fromResponse();
        AsyncHandler<GetAlarmRequest, GetAlarmResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAlarmRequest, GetAlarmResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAlarmHistoryResponse> getAlarmHistory(GetAlarmHistoryRequest request, AsyncHandler<GetAlarmHistoryRequest, GetAlarmHistoryResponse> handler) {
        LOG.trace("Called async getAlarmHistory");
        GetAlarmHistoryRequest interceptedRequest = GetAlarmHistoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAlarmHistoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAlarmHistoryResponse> transformer = GetAlarmHistoryConverter.fromResponse();
        AsyncHandler<GetAlarmHistoryRequest, GetAlarmHistoryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAlarmHistoryRequest, GetAlarmHistoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAlarmsResponse> listAlarms(ListAlarmsRequest request, AsyncHandler<ListAlarmsRequest, ListAlarmsResponse> handler) {
        LOG.trace("Called async listAlarms");
        ListAlarmsRequest interceptedRequest = ListAlarmsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAlarmsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAlarmsResponse> transformer = ListAlarmsConverter.fromResponse();
        AsyncHandler<ListAlarmsRequest, ListAlarmsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAlarmsRequest, ListAlarmsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAlarmsStatusResponse> listAlarmsStatus(ListAlarmsStatusRequest request, AsyncHandler<ListAlarmsStatusRequest, ListAlarmsStatusResponse> handler) {
        LOG.trace("Called async listAlarmsStatus");
        ListAlarmsStatusRequest interceptedRequest = ListAlarmsStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAlarmsStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAlarmsStatusResponse> transformer = ListAlarmsStatusConverter.fromResponse();
        AsyncHandler<ListAlarmsStatusRequest, ListAlarmsStatusResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAlarmsStatusRequest, ListAlarmsStatusResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListMetricsResponse> listMetrics(ListMetricsRequest request, AsyncHandler<ListMetricsRequest, ListMetricsResponse> handler) {
        LOG.trace("Called async listMetrics");
        ListMetricsRequest interceptedRequest = ListMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMetricsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMetricsResponse> transformer = ListMetricsConverter.fromResponse();
        AsyncHandler<ListMetricsRequest, ListMetricsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListMetricsRequest, ListMetricsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PostMetricDataResponse> postMetricData(PostMetricDataRequest request, AsyncHandler<PostMetricDataRequest, PostMetricDataResponse> handler) {
        LOG.trace("Called async postMetricData");
        PostMetricDataRequest interceptedRequest = PostMetricDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PostMetricDataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PostMetricDataResponse> transformer = PostMetricDataConverter.fromResponse();
        AsyncHandler<PostMetricDataRequest, PostMetricDataResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PostMetricDataRequest, PostMetricDataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemoveAlarmSuppressionResponse> removeAlarmSuppression(RemoveAlarmSuppressionRequest request, AsyncHandler<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse> handler) {
        LOG.trace("Called async removeAlarmSuppression");
        RemoveAlarmSuppressionRequest interceptedRequest = RemoveAlarmSuppressionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveAlarmSuppressionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveAlarmSuppressionResponse> transformer = RemoveAlarmSuppressionConverter.fromResponse();
        AsyncHandler<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeMetricsDataResponse> summarizeMetricsData(SummarizeMetricsDataRequest request, AsyncHandler<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse> handler) {
        LOG.trace("Called async summarizeMetricsData");
        SummarizeMetricsDataRequest interceptedRequest = SummarizeMetricsDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeMetricsDataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeMetricsDataResponse> transformer = SummarizeMetricsDataConverter.fromResponse();
        AsyncHandler<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAlarmResponse> updateAlarm(UpdateAlarmRequest request, AsyncHandler<UpdateAlarmRequest, UpdateAlarmResponse> handler) {
        LOG.trace("Called async updateAlarm");
        UpdateAlarmRequest interceptedRequest = UpdateAlarmConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAlarmConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAlarmResponse> transformer = UpdateAlarmConverter.fromResponse();
        AsyncHandler<UpdateAlarmRequest, UpdateAlarmResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAlarmRequest, UpdateAlarmResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MonitoringAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public MonitoringAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new MonitoringAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

