/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.monitoring.model.PostMetricDataResponseDetails;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import com.oracle.bmc.monitoring.responses.PostMetricDataResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostMetricDataConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PostMetricDataConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static PostMetricDataRequest interceptRequest(PostMetricDataRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, PostMetricDataRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getPostMetricDataDetails(), (String)"postMetricDataDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180401").path("metrics");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, PostMetricDataResponse> fromResponse() {
        Function<Response, PostMetricDataResponse> transformer = new Function<Response, PostMetricDataResponse>(){

            public PostMetricDataResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.monitoring.responses.PostMetricDataResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(PostMetricDataResponseDetails.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                PostMetricDataResponse.Builder builder = PostMetricDataResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.postMetricDataResponseDetails((PostMetricDataResponseDetails)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                PostMetricDataResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

