/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.monitoring.model.ListMetricsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListMetricsRequest
extends BmcRequest<ListMetricsDetails> {
    private String compartmentId;
    private ListMetricsDetails listMetricsDetails;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private Boolean compartmentIdInSubtree;

    @InternalSdk
    public ListMetricsDetails getBody$() {
        return this.listMetricsDetails;
    }

    @ConstructorProperties(value={"compartmentId", "listMetricsDetails", "opcRequestId", "page", "limit", "compartmentIdInSubtree"})
    ListMetricsRequest(String compartmentId, ListMetricsDetails listMetricsDetails, String opcRequestId, String page, Integer limit, Boolean compartmentIdInSubtree) {
        this.compartmentId = compartmentId;
        this.listMetricsDetails = listMetricsDetails;
        this.opcRequestId = opcRequestId;
        this.page = page;
        this.limit = limit;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ListMetricsDetails getListMetricsDetails() {
        return this.listMetricsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMetricsRequest, ListMetricsDetails> {
        private String compartmentId;
        private ListMetricsDetails listMetricsDetails;
        private String opcRequestId;
        private String page;
        private Integer limit;
        private Boolean compartmentIdInSubtree;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMetricsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.listMetricsDetails(o.getListMetricsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMetricsRequest build() {
            ListMetricsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ListMetricsDetails body) {
            this.listMetricsDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder listMetricsDetails(ListMetricsDetails listMetricsDetails) {
            this.listMetricsDetails = listMetricsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public ListMetricsRequest buildWithoutInvocationCallback() {
            return new ListMetricsRequest(this.compartmentId, this.listMetricsDetails, this.opcRequestId, this.page, this.limit, this.compartmentIdInSubtree);
        }

        public String toString() {
            return "ListMetricsRequest.Builder(compartmentId=" + this.compartmentId + ", listMetricsDetails=" + this.listMetricsDetails + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ", limit=" + this.limit + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ")";
        }
    }
}

