/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.monitoring.model.SummarizeMetricsDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class SummarizeMetricsDataRequest
extends BmcRequest<SummarizeMetricsDataDetails> {
    private String compartmentId;
    private SummarizeMetricsDataDetails summarizeMetricsDataDetails;
    private String opcRequestId;
    private Boolean compartmentIdInSubtree;

    @InternalSdk
    public SummarizeMetricsDataDetails getBody$() {
        return this.summarizeMetricsDataDetails;
    }

    @ConstructorProperties(value={"compartmentId", "summarizeMetricsDataDetails", "opcRequestId", "compartmentIdInSubtree"})
    SummarizeMetricsDataRequest(String compartmentId, SummarizeMetricsDataDetails summarizeMetricsDataDetails, String opcRequestId, Boolean compartmentIdInSubtree) {
        this.compartmentId = compartmentId;
        this.summarizeMetricsDataDetails = summarizeMetricsDataDetails;
        this.opcRequestId = opcRequestId;
        this.compartmentIdInSubtree = compartmentIdInSubtree;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public SummarizeMetricsDataDetails getSummarizeMetricsDataDetails() {
        return this.summarizeMetricsDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeMetricsDataRequest, SummarizeMetricsDataDetails> {
        private String compartmentId;
        private SummarizeMetricsDataDetails summarizeMetricsDataDetails;
        private String opcRequestId;
        private Boolean compartmentIdInSubtree;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeMetricsDataRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.summarizeMetricsDataDetails(o.getSummarizeMetricsDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeMetricsDataRequest build() {
            SummarizeMetricsDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SummarizeMetricsDataDetails body) {
            this.summarizeMetricsDataDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder summarizeMetricsDataDetails(SummarizeMetricsDataDetails summarizeMetricsDataDetails) {
            this.summarizeMetricsDataDetails = summarizeMetricsDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public SummarizeMetricsDataRequest buildWithoutInvocationCallback() {
            return new SummarizeMetricsDataRequest(this.compartmentId, this.summarizeMetricsDataDetails, this.opcRequestId, this.compartmentIdInSubtree);
        }

        public String toString() {
            return "SummarizeMetricsDataRequest.Builder(compartmentId=" + this.compartmentId + ", summarizeMetricsDataDetails=" + this.summarizeMetricsDataDetails + ", opcRequestId=" + this.opcRequestId + ", compartmentIdInSubtree=" + this.compartmentIdInSubtree + ")";
        }
    }
}

