/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.mysql.DbBackups;
import com.oracle.bmc.mysql.model.BackupSummary;
import com.oracle.bmc.mysql.requests.ListBackupsRequest;
import com.oracle.bmc.mysql.responses.ListBackupsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DbBackupsPaginators {
    private final DbBackups client;

    public Iterable<ListBackupsResponse> listBackupsResponseIterator(final ListBackupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBackupsRequest.Builder>(){

            public ListBackupsRequest.Builder get() {
                return ListBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackupsResponse, String>(){

            public String apply(ListBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackupsRequest.Builder>, ListBackupsRequest>(){

            public ListBackupsRequest apply(RequestBuilderAndToken<ListBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBackupsRequest, ListBackupsResponse>(){

            public ListBackupsResponse apply(ListBackupsRequest request) {
                return DbBackupsPaginators.this.client.listBackups(request);
            }
        });
    }

    public Iterable<BackupSummary> listBackupsRecordIterator(final ListBackupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBackupsRequest.Builder>(){

            public ListBackupsRequest.Builder get() {
                return ListBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBackupsResponse, String>(){

            public String apply(ListBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBackupsRequest.Builder>, ListBackupsRequest>(){

            public ListBackupsRequest apply(RequestBuilderAndToken<ListBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBackupsRequest, ListBackupsResponse>(){

            public ListBackupsResponse apply(ListBackupsRequest request) {
                return DbBackupsPaginators.this.client.listBackups(request);
            }
        }, (Function)new Function<ListBackupsResponse, List<BackupSummary>>(){

            public List<BackupSummary> apply(ListBackupsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DbBackupsPaginators(DbBackups client) {
        this.client = client;
    }
}

