/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.mysql.DbSystem;
import com.oracle.bmc.mysql.DbSystemPaginators;
import com.oracle.bmc.mysql.DbSystemWaiters;
import com.oracle.bmc.mysql.internal.http.AddAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.AddHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.CreateDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.DeleteAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.DeleteDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.DeleteHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.GenerateAnalyticsClusterMemoryEstimateConverter;
import com.oracle.bmc.mysql.internal.http.GenerateHeatWaveClusterMemoryEstimateConverter;
import com.oracle.bmc.mysql.internal.http.GetAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.GetAnalyticsClusterMemoryEstimateConverter;
import com.oracle.bmc.mysql.internal.http.GetDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.GetHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.GetHeatWaveClusterMemoryEstimateConverter;
import com.oracle.bmc.mysql.internal.http.ListDbSystemsConverter;
import com.oracle.bmc.mysql.internal.http.RestartAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.RestartDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.RestartHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.StartAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.StartDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.StartHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.StopAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.StopDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.StopHeatWaveClusterConverter;
import com.oracle.bmc.mysql.internal.http.UpdateAnalyticsClusterConverter;
import com.oracle.bmc.mysql.internal.http.UpdateDbSystemConverter;
import com.oracle.bmc.mysql.internal.http.UpdateHeatWaveClusterConverter;
import com.oracle.bmc.mysql.requests.AddAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.AddHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.CreateDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.DeleteDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.GenerateAnalyticsClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GenerateHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetAnalyticsClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.GetDbSystemRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.ListDbSystemsRequest;
import com.oracle.bmc.mysql.requests.RestartAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.RestartDbSystemRequest;
import com.oracle.bmc.mysql.requests.RestartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StartAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.StartDbSystemRequest;
import com.oracle.bmc.mysql.requests.StartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StopAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.StopDbSystemRequest;
import com.oracle.bmc.mysql.requests.StopHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.UpdateAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.UpdateDbSystemRequest;
import com.oracle.bmc.mysql.requests.UpdateHeatWaveClusterRequest;
import com.oracle.bmc.mysql.responses.AddAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.AddHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.CreateDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.DeleteDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.GenerateAnalyticsClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GenerateHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetAnalyticsClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.GetDbSystemResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.ListDbSystemsResponse;
import com.oracle.bmc.mysql.responses.RestartAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.RestartDbSystemResponse;
import com.oracle.bmc.mysql.responses.RestartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StartAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.StartDbSystemResponse;
import com.oracle.bmc.mysql.responses.StartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StopAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.StopDbSystemResponse;
import com.oracle.bmc.mysql.responses.StopHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.UpdateAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.UpdateDbSystemResponse;
import com.oracle.bmc.mysql.responses.UpdateHeatWaveClusterResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSystemClient
implements DbSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DbSystemClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBSYSTEM").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DbSystemWaiters waiters;
    private final DbSystemPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public DbSystemClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DbSystemClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DbSystemClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DbSystem-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DbSystemWaiters(executorService, this);
        this.paginators = new DbSystemPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AddAnalyticsClusterResponse addAnalyticsCluster(AddAnalyticsClusterRequest request) {
        LOG.trace("Called addAnalyticsCluster");
        AddAnalyticsClusterRequest interceptedRequest = AddAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddAnalyticsClusterResponse> transformer = AddAnalyticsClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddAnalyticsClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddAnalyticsClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddAnalyticsClusterDetails(), (BmcRequest)retriedRequest);
                return (AddAnalyticsClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AddHeatWaveClusterResponse addHeatWaveCluster(AddHeatWaveClusterRequest request) {
        LOG.trace("Called addHeatWaveCluster");
        AddHeatWaveClusterRequest interceptedRequest = AddHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddHeatWaveClusterResponse> transformer = AddHeatWaveClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddHeatWaveClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddHeatWaveClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddHeatWaveClusterDetails(), (BmcRequest)retriedRequest);
                return (AddHeatWaveClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDbSystemResponse createDbSystem(CreateDbSystemRequest request) {
        LOG.trace("Called createDbSystem");
        CreateDbSystemRequest interceptedRequest = CreateDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDbSystemResponse> transformer = CreateDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDbSystemResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDbSystemResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDbSystemDetails(), (BmcRequest)retriedRequest);
                return (CreateDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAnalyticsClusterResponse deleteAnalyticsCluster(DeleteAnalyticsClusterRequest request) {
        LOG.trace("Called deleteAnalyticsCluster");
        DeleteAnalyticsClusterRequest interceptedRequest = DeleteAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAnalyticsClusterResponse> transformer = DeleteAnalyticsClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteAnalyticsClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteAnalyticsClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteAnalyticsClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDbSystemResponse deleteDbSystem(DeleteDbSystemRequest request) {
        LOG.trace("Called deleteDbSystem");
        DeleteDbSystemRequest interceptedRequest = DeleteDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDbSystemResponse> transformer = DeleteDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDbSystemResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDbSystemResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteHeatWaveClusterResponse deleteHeatWaveCluster(DeleteHeatWaveClusterRequest request) {
        LOG.trace("Called deleteHeatWaveCluster");
        DeleteHeatWaveClusterRequest interceptedRequest = DeleteHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteHeatWaveClusterResponse> transformer = DeleteHeatWaveClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteHeatWaveClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteHeatWaveClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteHeatWaveClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GenerateAnalyticsClusterMemoryEstimateResponse generateAnalyticsClusterMemoryEstimate(GenerateAnalyticsClusterMemoryEstimateRequest request) {
        LOG.trace("Called generateAnalyticsClusterMemoryEstimate");
        GenerateAnalyticsClusterMemoryEstimateRequest interceptedRequest = GenerateAnalyticsClusterMemoryEstimateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateAnalyticsClusterMemoryEstimateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateAnalyticsClusterMemoryEstimateResponse> transformer = GenerateAnalyticsClusterMemoryEstimateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (GenerateAnalyticsClusterMemoryEstimateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GenerateAnalyticsClusterMemoryEstimateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (GenerateAnalyticsClusterMemoryEstimateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GenerateHeatWaveClusterMemoryEstimateResponse generateHeatWaveClusterMemoryEstimate(GenerateHeatWaveClusterMemoryEstimateRequest request) {
        LOG.trace("Called generateHeatWaveClusterMemoryEstimate");
        GenerateHeatWaveClusterMemoryEstimateRequest interceptedRequest = GenerateHeatWaveClusterMemoryEstimateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateHeatWaveClusterMemoryEstimateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateHeatWaveClusterMemoryEstimateResponse> transformer = GenerateHeatWaveClusterMemoryEstimateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (GenerateHeatWaveClusterMemoryEstimateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GenerateHeatWaveClusterMemoryEstimateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (GenerateHeatWaveClusterMemoryEstimateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAnalyticsClusterResponse getAnalyticsCluster(GetAnalyticsClusterRequest request) {
        LOG.trace("Called getAnalyticsCluster");
        GetAnalyticsClusterRequest interceptedRequest = GetAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAnalyticsClusterResponse> transformer = GetAnalyticsClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAnalyticsClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAnalyticsClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAnalyticsClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAnalyticsClusterMemoryEstimateResponse getAnalyticsClusterMemoryEstimate(GetAnalyticsClusterMemoryEstimateRequest request) {
        LOG.trace("Called getAnalyticsClusterMemoryEstimate");
        GetAnalyticsClusterMemoryEstimateRequest interceptedRequest = GetAnalyticsClusterMemoryEstimateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAnalyticsClusterMemoryEstimateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAnalyticsClusterMemoryEstimateResponse> transformer = GetAnalyticsClusterMemoryEstimateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAnalyticsClusterMemoryEstimateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAnalyticsClusterMemoryEstimateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAnalyticsClusterMemoryEstimateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDbSystemResponse getDbSystem(GetDbSystemRequest request) {
        LOG.trace("Called getDbSystem");
        GetDbSystemRequest interceptedRequest = GetDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDbSystemResponse> transformer = GetDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDbSystemResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDbSystemResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetHeatWaveClusterResponse getHeatWaveCluster(GetHeatWaveClusterRequest request) {
        LOG.trace("Called getHeatWaveCluster");
        GetHeatWaveClusterRequest interceptedRequest = GetHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHeatWaveClusterResponse> transformer = GetHeatWaveClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetHeatWaveClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetHeatWaveClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetHeatWaveClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetHeatWaveClusterMemoryEstimateResponse getHeatWaveClusterMemoryEstimate(GetHeatWaveClusterMemoryEstimateRequest request) {
        LOG.trace("Called getHeatWaveClusterMemoryEstimate");
        GetHeatWaveClusterMemoryEstimateRequest interceptedRequest = GetHeatWaveClusterMemoryEstimateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHeatWaveClusterMemoryEstimateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHeatWaveClusterMemoryEstimateResponse> transformer = GetHeatWaveClusterMemoryEstimateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetHeatWaveClusterMemoryEstimateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetHeatWaveClusterMemoryEstimateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetHeatWaveClusterMemoryEstimateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbSystemsResponse listDbSystems(ListDbSystemsRequest request) {
        LOG.trace("Called listDbSystems");
        ListDbSystemsRequest interceptedRequest = ListDbSystemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbSystemsResponse> transformer = ListDbSystemsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDbSystemsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDbSystemsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDbSystemsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestartAnalyticsClusterResponse restartAnalyticsCluster(RestartAnalyticsClusterRequest request) {
        LOG.trace("Called restartAnalyticsCluster");
        RestartAnalyticsClusterRequest interceptedRequest = RestartAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestartAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestartAnalyticsClusterResponse> transformer = RestartAnalyticsClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RestartAnalyticsClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RestartAnalyticsClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RestartAnalyticsClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestartDbSystemResponse restartDbSystem(RestartDbSystemRequest request) {
        LOG.trace("Called restartDbSystem");
        RestartDbSystemRequest interceptedRequest = RestartDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestartDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestartDbSystemResponse> transformer = RestartDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RestartDbSystemResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RestartDbSystemResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRestartDbSystemDetails(), (BmcRequest)retriedRequest);
                return (RestartDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestartHeatWaveClusterResponse restartHeatWaveCluster(RestartHeatWaveClusterRequest request) {
        LOG.trace("Called restartHeatWaveCluster");
        RestartHeatWaveClusterRequest interceptedRequest = RestartHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestartHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestartHeatWaveClusterResponse> transformer = RestartHeatWaveClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RestartHeatWaveClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RestartHeatWaveClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RestartHeatWaveClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartAnalyticsClusterResponse startAnalyticsCluster(StartAnalyticsClusterRequest request) {
        LOG.trace("Called startAnalyticsCluster");
        StartAnalyticsClusterRequest interceptedRequest = StartAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartAnalyticsClusterResponse> transformer = StartAnalyticsClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StartAnalyticsClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StartAnalyticsClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StartAnalyticsClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartDbSystemResponse startDbSystem(StartDbSystemRequest request) {
        LOG.trace("Called startDbSystem");
        StartDbSystemRequest interceptedRequest = StartDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartDbSystemResponse> transformer = StartDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StartDbSystemResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StartDbSystemResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StartDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartHeatWaveClusterResponse startHeatWaveCluster(StartHeatWaveClusterRequest request) {
        LOG.trace("Called startHeatWaveCluster");
        StartHeatWaveClusterRequest interceptedRequest = StartHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartHeatWaveClusterResponse> transformer = StartHeatWaveClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StartHeatWaveClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StartHeatWaveClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StartHeatWaveClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopAnalyticsClusterResponse stopAnalyticsCluster(StopAnalyticsClusterRequest request) {
        LOG.trace("Called stopAnalyticsCluster");
        StopAnalyticsClusterRequest interceptedRequest = StopAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopAnalyticsClusterResponse> transformer = StopAnalyticsClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StopAnalyticsClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StopAnalyticsClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StopAnalyticsClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopDbSystemResponse stopDbSystem(StopDbSystemRequest request) {
        LOG.trace("Called stopDbSystem");
        StopDbSystemRequest interceptedRequest = StopDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopDbSystemResponse> transformer = StopDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StopDbSystemResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StopDbSystemResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getStopDbSystemDetails(), (BmcRequest)retriedRequest);
                return (StopDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopHeatWaveClusterResponse stopHeatWaveCluster(StopHeatWaveClusterRequest request) {
        LOG.trace("Called stopHeatWaveCluster");
        StopHeatWaveClusterRequest interceptedRequest = StopHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopHeatWaveClusterResponse> transformer = StopHeatWaveClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StopHeatWaveClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StopHeatWaveClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StopHeatWaveClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAnalyticsClusterResponse updateAnalyticsCluster(UpdateAnalyticsClusterRequest request) {
        LOG.trace("Called updateAnalyticsCluster");
        UpdateAnalyticsClusterRequest interceptedRequest = UpdateAnalyticsClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAnalyticsClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAnalyticsClusterResponse> transformer = UpdateAnalyticsClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateAnalyticsClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAnalyticsClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateAnalyticsClusterDetails(), (BmcRequest)retriedRequest);
                return (UpdateAnalyticsClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDbSystemResponse updateDbSystem(UpdateDbSystemRequest request) {
        LOG.trace("Called updateDbSystem");
        UpdateDbSystemRequest interceptedRequest = UpdateDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDbSystemResponse> transformer = UpdateDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDbSystemResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDbSystemResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDbSystemDetails(), (BmcRequest)retriedRequest);
                return (UpdateDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateHeatWaveClusterResponse updateHeatWaveCluster(UpdateHeatWaveClusterRequest request) {
        LOG.trace("Called updateHeatWaveCluster");
        UpdateHeatWaveClusterRequest interceptedRequest = UpdateHeatWaveClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHeatWaveClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHeatWaveClusterResponse> transformer = UpdateHeatWaveClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateHeatWaveClusterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateHeatWaveClusterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateHeatWaveClusterDetails(), (BmcRequest)retriedRequest);
                return (UpdateHeatWaveClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DbSystemWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DbSystemPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbSystemClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DbSystemClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DbSystemClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

