/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.mysql.MysqlaasAsync;
import com.oracle.bmc.mysql.internal.http.CreateConfigurationConverter;
import com.oracle.bmc.mysql.internal.http.DeleteConfigurationConverter;
import com.oracle.bmc.mysql.internal.http.GetConfigurationConverter;
import com.oracle.bmc.mysql.internal.http.ListConfigurationsConverter;
import com.oracle.bmc.mysql.internal.http.ListShapesConverter;
import com.oracle.bmc.mysql.internal.http.ListVersionsConverter;
import com.oracle.bmc.mysql.internal.http.UpdateConfigurationConverter;
import com.oracle.bmc.mysql.requests.CreateConfigurationRequest;
import com.oracle.bmc.mysql.requests.DeleteConfigurationRequest;
import com.oracle.bmc.mysql.requests.GetConfigurationRequest;
import com.oracle.bmc.mysql.requests.ListConfigurationsRequest;
import com.oracle.bmc.mysql.requests.ListShapesRequest;
import com.oracle.bmc.mysql.requests.ListVersionsRequest;
import com.oracle.bmc.mysql.requests.UpdateConfigurationRequest;
import com.oracle.bmc.mysql.responses.CreateConfigurationResponse;
import com.oracle.bmc.mysql.responses.DeleteConfigurationResponse;
import com.oracle.bmc.mysql.responses.GetConfigurationResponse;
import com.oracle.bmc.mysql.responses.ListConfigurationsResponse;
import com.oracle.bmc.mysql.responses.ListShapesResponse;
import com.oracle.bmc.mysql.responses.ListVersionsResponse;
import com.oracle.bmc.mysql.responses.UpdateConfigurationResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlaasAsyncClient
implements MysqlaasAsync {
    private static final Logger LOG = LoggerFactory.getLogger(MysqlaasAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MYSQLAAS").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public MysqlaasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public MysqlaasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public MysqlaasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public MysqlaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public MysqlaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public MysqlaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public MysqlaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public MysqlaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateConfigurationResponse> createConfiguration(CreateConfigurationRequest request, AsyncHandler<CreateConfigurationRequest, CreateConfigurationResponse> handler) {
        LOG.trace("Called async createConfiguration");
        CreateConfigurationRequest interceptedRequest = CreateConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateConfigurationResponse> transformer = CreateConfigurationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateConfigurationRequest, CreateConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateConfigurationRequest, CreateConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteConfigurationResponse> deleteConfiguration(DeleteConfigurationRequest request, AsyncHandler<DeleteConfigurationRequest, DeleteConfigurationResponse> handler) {
        LOG.trace("Called async deleteConfiguration");
        DeleteConfigurationRequest interceptedRequest = DeleteConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConfigurationResponse> transformer = DeleteConfigurationConverter.fromResponse();
        AsyncHandler<DeleteConfigurationRequest, DeleteConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteConfigurationRequest, DeleteConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request, AsyncHandler<GetConfigurationRequest, GetConfigurationResponse> handler) {
        LOG.trace("Called async getConfiguration");
        GetConfigurationRequest interceptedRequest = GetConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConfigurationResponse> transformer = GetConfigurationConverter.fromResponse();
        AsyncHandler<GetConfigurationRequest, GetConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConfigurationRequest, GetConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConfigurationsResponse> listConfigurations(ListConfigurationsRequest request, AsyncHandler<ListConfigurationsRequest, ListConfigurationsResponse> handler) {
        LOG.trace("Called async listConfigurations");
        ListConfigurationsRequest interceptedRequest = ListConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConfigurationsResponse> transformer = ListConfigurationsConverter.fromResponse();
        AsyncHandler<ListConfigurationsRequest, ListConfigurationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConfigurationsRequest, ListConfigurationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListShapesResponse> listShapes(ListShapesRequest request, AsyncHandler<ListShapesRequest, ListShapesResponse> handler) {
        LOG.trace("Called async listShapes");
        ListShapesRequest interceptedRequest = ListShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListShapesResponse> transformer = ListShapesConverter.fromResponse();
        AsyncHandler<ListShapesRequest, ListShapesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListShapesRequest, ListShapesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListVersionsResponse> listVersions(ListVersionsRequest request, AsyncHandler<ListVersionsRequest, ListVersionsResponse> handler) {
        LOG.trace("Called async listVersions");
        ListVersionsRequest interceptedRequest = ListVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVersionsResponse> transformer = ListVersionsConverter.fromResponse();
        AsyncHandler<ListVersionsRequest, ListVersionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListVersionsRequest, ListVersionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request, AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse> handler) {
        LOG.trace("Called async updateConfiguration");
        UpdateConfigurationRequest interceptedRequest = UpdateConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConfigurationResponse> transformer = UpdateConfigurationConverter.fromResponse();
        AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateConfigurationRequest, UpdateConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MysqlaasAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public MysqlaasAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new MysqlaasAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

