/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.mysql.Mysqlaas;
import com.oracle.bmc.mysql.model.ConfigurationSummary;
import com.oracle.bmc.mysql.requests.ListConfigurationsRequest;
import com.oracle.bmc.mysql.responses.ListConfigurationsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class MysqlaasPaginators {
    private final Mysqlaas client;

    public Iterable<ListConfigurationsResponse> listConfigurationsResponseIterator(final ListConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConfigurationsRequest.Builder>(){

            public ListConfigurationsRequest.Builder get() {
                return ListConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationsResponse, String>(){

            public String apply(ListConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationsRequest.Builder>, ListConfigurationsRequest>(){

            public ListConfigurationsRequest apply(RequestBuilderAndToken<ListConfigurationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListConfigurationsRequest, ListConfigurationsResponse>(){

            public ListConfigurationsResponse apply(ListConfigurationsRequest request) {
                return MysqlaasPaginators.this.client.listConfigurations(request);
            }
        });
    }

    public Iterable<ConfigurationSummary> listConfigurationsRecordIterator(final ListConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConfigurationsRequest.Builder>(){

            public ListConfigurationsRequest.Builder get() {
                return ListConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationsResponse, String>(){

            public String apply(ListConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationsRequest.Builder>, ListConfigurationsRequest>(){

            public ListConfigurationsRequest apply(RequestBuilderAndToken<ListConfigurationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListConfigurationsRequest, ListConfigurationsResponse>(){

            public ListConfigurationsResponse apply(ListConfigurationsRequest request) {
                return MysqlaasPaginators.this.client.listConfigurations(request);
            }
        }, (Function)new Function<ListConfigurationsResponse, List<ConfigurationSummary>>(){

            public List<ConfigurationSummary> apply(ListConfigurationsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public MysqlaasPaginators(Mysqlaas client) {
        this.client = client;
    }
}

