/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.mysql.WorkRequests;
import com.oracle.bmc.mysql.requests.GetWorkRequestRequest;
import com.oracle.bmc.mysql.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;

public class WorkRequestsWaiters {
    private final ExecutorService executorService;
    private final WorkRequests client;

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return WorkRequestsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public WorkRequestsWaiters(ExecutorService executorService, WorkRequests client) {
        this.executorService = executorService;
        this.client = client;
    }
}

