/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.mysql.model.Configuration;
import com.oracle.bmc.mysql.requests.CreateConfigurationRequest;
import com.oracle.bmc.mysql.responses.CreateConfigurationResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateConfigurationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateConfigurationConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateConfigurationRequest interceptRequest(CreateConfigurationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateConfigurationRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateConfigurationDetails(), (String)"createConfigurationDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190415").path("configurations");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateConfigurationResponse> fromResponse() {
        Function<Response, CreateConfigurationResponse> transformer = new Function<Response, CreateConfigurationResponse>(){

            public CreateConfigurationResponse apply(Response rawResponse) {
                Optional opcWorkRequestIdHeader;
                Optional opcRequestIdHeader;
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.mysql.responses.CreateConfigurationResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Configuration.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateConfigurationResponse.Builder builder = CreateConfigurationResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.configuration((Configuration)response.getItem());
                Optional locationHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"location");
                if (locationHeader.isPresent()) {
                    builder.location((String)HeaderUtils.toValue((String)"location", (String)((String)((List)locationHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                CreateConfigurationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

