/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.mysql.model.CaCertificate;
import com.oracle.bmc.mysql.model.ChannelSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ChannelSourceMysql
extends ChannelSource {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="sslMode")
    private final SslMode sslMode;
    @JsonProperty(value="sslCaCertificate")
    private final CaCertificate sslCaCertificate;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public ChannelSourceMysql(String hostname, Integer port, String username, SslMode sslMode, CaCertificate sslCaCertificate) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.sslMode = sslMode;
        this.sslCaCertificate = sslCaCertificate;
    }

    public Builder toBuilder() {
        return new Builder().hostname(this.hostname).port(this.port).username(this.username).sslMode(this.sslMode).sslCaCertificate(this.sslCaCertificate);
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public CaCertificate getSslCaCertificate() {
        return this.sslCaCertificate;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "ChannelSourceMysql(super=" + super.toString() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", sslMode=" + (Object)((Object)this.getSslMode()) + ", sslCaCertificate=" + this.getSslCaCertificate() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelSourceMysql)) {
            return false;
        }
        ChannelSourceMysql other = (ChannelSourceMysql)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        SslMode this$sslMode = this.getSslMode();
        SslMode other$sslMode = other.getSslMode();
        if (this$sslMode == null ? other$sslMode != null : !((Object)((Object)this$sslMode)).equals((Object)other$sslMode)) {
            return false;
        }
        CaCertificate this$sslCaCertificate = this.getSslCaCertificate();
        CaCertificate other$sslCaCertificate = other.getSslCaCertificate();
        if (this$sslCaCertificate == null ? other$sslCaCertificate != null : !((Object)this$sslCaCertificate).equals(other$sslCaCertificate)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChannelSourceMysql;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        SslMode $sslMode = this.getSslMode();
        result = result * 59 + ($sslMode == null ? 43 : ((Object)((Object)$sslMode)).hashCode());
        CaCertificate $sslCaCertificate = this.getSslCaCertificate();
        result = result * 59 + ($sslCaCertificate == null ? 43 : ((Object)$sslCaCertificate).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum SslMode {
        VerifyIdentity("VERIFY_IDENTITY"),
        VerifyCa("VERIFY_CA"),
        Required("REQUIRED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SslMode> map;

        private SslMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SslMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SslMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SslMode.class);
            map = new HashMap<String, SslMode>();
            for (SslMode v : SslMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="sslMode")
        private SslMode sslMode;
        @JsonProperty(value="sslCaCertificate")
        private CaCertificate sslCaCertificate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder sslMode(SslMode sslMode) {
            this.sslMode = sslMode;
            this.__explicitlySet__.add("sslMode");
            return this;
        }

        public Builder sslCaCertificate(CaCertificate sslCaCertificate) {
            this.sslCaCertificate = sslCaCertificate;
            this.__explicitlySet__.add("sslCaCertificate");
            return this;
        }

        public ChannelSourceMysql build() {
            ChannelSourceMysql __instance__ = new ChannelSourceMysql(this.hostname, this.port, this.username, this.sslMode, this.sslCaCertificate);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(ChannelSourceMysql o) {
            Builder copiedBuilder = this.hostname(o.getHostname()).port(o.getPort()).username(o.getUsername()).sslMode(o.getSslMode()).sslCaCertificate(o.getSslCaCertificate());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "ChannelSourceMysql.Builder(hostname=" + this.hostname + ", port=" + this.port + ", username=" + this.username + ", sslMode=" + (Object)((Object)this.sslMode) + ", sslCaCertificate=" + this.sslCaCertificate + ")";
        }
    }
}

