/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemEndpoint {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="portX")
    private final Integer portX;
    @JsonProperty(value="modes")
    private final List<Modes> modes;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="statusDetails")
    private final String statusDetails;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().hostname(this.hostname).ipAddress(this.ipAddress).port(this.port).portX(this.portX).modes(this.modes).status(this.status).statusDetails(this.statusDetails);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getPortX() {
        return this.portX;
    }

    public List<Modes> getModes() {
        return this.modes;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbSystemEndpoint)) {
            return false;
        }
        DbSystemEndpoint other = (DbSystemEndpoint)o;
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$portX = this.getPortX();
        Integer other$portX = other.getPortX();
        if (this$portX == null ? other$portX != null : !((Object)this$portX).equals(other$portX)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        List<Modes> this$modes = this.getModes();
        List<Modes> other$modes = other.getModes();
        if (this$modes == null ? other$modes != null : !((Object)this$modes).equals(other$modes)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$statusDetails = this.getStatusDetails();
        String other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $portX = this.getPortX();
        result = result * 59 + ($portX == null ? 43 : ((Object)$portX).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        List<Modes> $modes = this.getModes();
        result = result * 59 + ($modes == null ? 43 : ((Object)$modes).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $statusDetails = this.getStatusDetails();
        result = result * 59 + ($statusDetails == null ? 43 : $statusDetails.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "DbSystemEndpoint(hostname=" + this.getHostname() + ", ipAddress=" + this.getIpAddress() + ", port=" + this.getPort() + ", portX=" + this.getPortX() + ", modes=" + this.getModes() + ", status=" + (Object)((Object)this.getStatus()) + ", statusDetails=" + this.getStatusDetails() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"hostname", "ipAddress", "port", "portX", "modes", "status", "statusDetails"})
    @Deprecated
    public DbSystemEndpoint(String hostname, String ipAddress, Integer port, Integer portX, List<Modes> modes, Status status, String statusDetails) {
        this.hostname = hostname;
        this.ipAddress = ipAddress;
        this.port = port;
        this.portX = portX;
        this.modes = modes;
        this.status = status;
        this.statusDetails = statusDetails;
    }

    public static enum Status {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Modes {
        Read("READ"),
        Write("WRITE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Modes> map;

        private Modes(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Modes create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Modes', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Modes.class);
            map = new HashMap<String, Modes>();
            for (Modes v : Modes.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="portX")
        private Integer portX;
        @JsonProperty(value="modes")
        private List<Modes> modes;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="statusDetails")
        private String statusDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder portX(Integer portX) {
            this.portX = portX;
            this.__explicitlySet__.add("portX");
            return this;
        }

        public Builder modes(List<Modes> modes) {
            this.modes = modes;
            this.__explicitlySet__.add("modes");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            this.__explicitlySet__.add("statusDetails");
            return this;
        }

        public DbSystemEndpoint build() {
            DbSystemEndpoint __instance__ = new DbSystemEndpoint(this.hostname, this.ipAddress, this.port, this.portX, this.modes, this.status, this.statusDetails);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DbSystemEndpoint o) {
            Builder copiedBuilder = this.hostname(o.getHostname()).ipAddress(o.getIpAddress()).port(o.getPort()).portX(o.getPortX()).modes(o.getModes()).status(o.getStatus()).statusDetails(o.getStatusDetails());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DbSystemEndpoint.Builder(hostname=" + this.hostname + ", ipAddress=" + this.ipAddress + ", port=" + this.port + ", portX=" + this.portX + ", modes=" + this.modes + ", status=" + (Object)((Object)this.status) + ", statusDetails=" + this.statusDetails + ")";
        }
    }
}

