/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.mysql.model.Channel;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListChannelsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private String dbSystemId;
    private String channelId;
    private String displayName;
    private Channel.LifecycleState lifecycleState;
    private Boolean isEnabled;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "dbSystemId", "channelId", "displayName", "lifecycleState", "isEnabled", "sortBy", "sortOrder", "limit", "page"})
    ListChannelsRequest(String compartmentId, String opcRequestId, String dbSystemId, String channelId, String displayName, Channel.LifecycleState lifecycleState, Boolean isEnabled, SortBy sortBy, SortOrder sortOrder, Integer limit, String page) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.dbSystemId = dbSystemId;
        this.channelId = channelId;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.isEnabled = isEnabled;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Channel.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListChannelsRequest, Void> {
        private String compartmentId;
        private String opcRequestId;
        private String dbSystemId;
        private String channelId;
        private String displayName;
        private Channel.LifecycleState lifecycleState;
        private Boolean isEnabled;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListChannelsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.dbSystemId(o.getDbSystemId());
            this.channelId(o.getChannelId());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.isEnabled(o.getIsEnabled());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListChannelsRequest build() {
            ListChannelsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(Channel.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListChannelsRequest buildWithoutInvocationCallback() {
            return new ListChannelsRequest(this.compartmentId, this.opcRequestId, this.dbSystemId, this.channelId, this.displayName, this.lifecycleState, this.isEnabled, this.sortBy, this.sortOrder, this.limit, this.page);
        }

        public String toString() {
            return "ListChannelsRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", dbSystemId=" + this.dbSystemId + ", channelId=" + this.channelId + ", displayName=" + this.displayName + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", isEnabled=" + this.isEnabled + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        DisplayName("displayName"),
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

