/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.mysql.model.Configuration;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListConfigurationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private String configurationId;
    private Configuration.LifecycleState lifecycleState;
    private List<Type> type;
    private String displayName;
    private String shapeName;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "configurationId", "lifecycleState", "type", "displayName", "shapeName", "sortBy", "sortOrder", "limit", "page"})
    ListConfigurationsRequest(String compartmentId, String opcRequestId, String configurationId, Configuration.LifecycleState lifecycleState, List<Type> type, String displayName, String shapeName, SortBy sortBy, SortOrder sortOrder, Integer limit, String page) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.configurationId = configurationId;
        this.lifecycleState = lifecycleState;
        this.type = type;
        this.displayName = displayName;
        this.shapeName = shapeName;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public Configuration.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public List<Type> getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListConfigurationsRequest, Void> {
        private String compartmentId;
        private String opcRequestId;
        private String configurationId;
        private Configuration.LifecycleState lifecycleState;
        private List<Type> type;
        private String displayName;
        private String shapeName;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListConfigurationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.configurationId(o.getConfigurationId());
            this.lifecycleState(o.getLifecycleState());
            this.type(o.getType());
            this.displayName(o.getDisplayName());
            this.shapeName(o.getShapeName());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListConfigurationsRequest build() {
            ListConfigurationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public Builder lifecycleState(Configuration.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder type(List<Type> type) {
            this.type = type;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListConfigurationsRequest buildWithoutInvocationCallback() {
            return new ListConfigurationsRequest(this.compartmentId, this.opcRequestId, this.configurationId, this.lifecycleState, this.type, this.displayName, this.shapeName, this.sortBy, this.sortOrder, this.limit, this.page);
        }

        public String toString() {
            return "ListConfigurationsRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", configurationId=" + this.configurationId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", type=" + this.type + ", displayName=" + this.displayName + ", shapeName=" + this.shapeName + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        DisplayName("displayName"),
        ShapeName("shapeName"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type {
        Default("DEFAULT"),
        Custom("CUSTOM");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

