/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.networkloadbalancer.NetworkLoadBalancer;
import com.oracle.bmc.networkloadbalancer.NetworkLoadBalancerPaginators;
import com.oracle.bmc.networkloadbalancer.NetworkLoadBalancerWaiters;
import com.oracle.bmc.networkloadbalancer.internal.http.ChangeNetworkLoadBalancerCompartmentConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.CreateBackendConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.CreateBackendSetConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.CreateListenerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.CreateNetworkLoadBalancerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.DeleteBackendConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.DeleteBackendSetConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.DeleteListenerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.DeleteNetworkLoadBalancerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetBackendConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetBackendHealthConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetBackendSetConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetBackendSetHealthConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetHealthCheckerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetListenerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetNetworkLoadBalancerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetNetworkLoadBalancerHealthConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListBackendSetsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListBackendsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListListenersConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListNetworkLoadBalancerHealthsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListNetworkLoadBalancersConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListNetworkLoadBalancersPoliciesConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListNetworkLoadBalancersProtocolsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateBackendConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateBackendSetConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateHealthCheckerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateListenerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateNetworkLoadBalancerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateNetworkSecurityGroupsConverter;
import com.oracle.bmc.networkloadbalancer.requests.ChangeNetworkLoadBalancerCompartmentRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendHealthRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendSetHealthRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetHealthCheckerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetNetworkLoadBalancerHealthRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetWorkRequestRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListBackendSetsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListBackendsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListListenersRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancerHealthsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersPoliciesRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersProtocolsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateHealthCheckerRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateNetworkSecurityGroupsRequest;
import com.oracle.bmc.networkloadbalancer.responses.ChangeNetworkLoadBalancerCompartmentResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendHealthResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendSetHealthResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetHealthCheckerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetNetworkLoadBalancerHealthResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetWorkRequestResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListBackendSetsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListBackendsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListListenersResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancerHealthsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersPoliciesResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersProtocolsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateHealthCheckerResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateNetworkSecurityGroupsResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkLoadBalancerClient
implements NetworkLoadBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkLoadBalancerClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NETWORKLOADBALANCER").serviceEndpointPrefix("").serviceEndpointTemplate("https://network-load-balancer-api.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final NetworkLoadBalancerWaiters waiters;
    private final NetworkLoadBalancerPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public NetworkLoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public NetworkLoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public NetworkLoadBalancerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected NetworkLoadBalancerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("NetworkLoadBalancer-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new NetworkLoadBalancerWaiters(executorService, this);
        this.paginators = new NetworkLoadBalancerPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeNetworkLoadBalancerCompartmentResponse changeNetworkLoadBalancerCompartment(ChangeNetworkLoadBalancerCompartmentRequest request) {
        LOG.trace("Called changeNetworkLoadBalancerCompartment");
        ChangeNetworkLoadBalancerCompartmentRequest interceptedRequest = ChangeNetworkLoadBalancerCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeNetworkLoadBalancerCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeNetworkLoadBalancerCompartmentResponse> transformer = ChangeNetworkLoadBalancerCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeNetworkLoadBalancerCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeNetworkLoadBalancerCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeNetworkLoadBalancerCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeNetworkLoadBalancerCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBackendResponse createBackend(CreateBackendRequest request) {
        LOG.trace("Called createBackend");
        CreateBackendRequest interceptedRequest = CreateBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBackendResponse> transformer = CreateBackendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateBackendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBackendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBackendDetails(), (BmcRequest)retriedRequest);
                return (CreateBackendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBackendSetResponse createBackendSet(CreateBackendSetRequest request) {
        LOG.trace("Called createBackendSet");
        CreateBackendSetRequest interceptedRequest = CreateBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBackendSetResponse> transformer = CreateBackendSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateBackendSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBackendSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBackendSetDetails(), (BmcRequest)retriedRequest);
                return (CreateBackendSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateListenerResponse createListener(CreateListenerRequest request) {
        LOG.trace("Called createListener");
        CreateListenerRequest interceptedRequest = CreateListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateListenerResponse> transformer = CreateListenerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateListenerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateListenerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateListenerDetails(), (BmcRequest)retriedRequest);
                return (CreateListenerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateNetworkLoadBalancerResponse createNetworkLoadBalancer(CreateNetworkLoadBalancerRequest request) {
        LOG.trace("Called createNetworkLoadBalancer");
        CreateNetworkLoadBalancerRequest interceptedRequest = CreateNetworkLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNetworkLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateNetworkLoadBalancerResponse> transformer = CreateNetworkLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateNetworkLoadBalancerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateNetworkLoadBalancerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateNetworkLoadBalancerDetails(), (BmcRequest)retriedRequest);
                return (CreateNetworkLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBackendResponse deleteBackend(DeleteBackendRequest request) {
        LOG.trace("Called deleteBackend");
        DeleteBackendRequest interceptedRequest = DeleteBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBackendResponse> transformer = DeleteBackendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteBackendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBackendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBackendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBackendSetResponse deleteBackendSet(DeleteBackendSetRequest request) {
        LOG.trace("Called deleteBackendSet");
        DeleteBackendSetRequest interceptedRequest = DeleteBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBackendSetResponse> transformer = DeleteBackendSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteBackendSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBackendSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBackendSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest request) {
        LOG.trace("Called deleteListener");
        DeleteListenerRequest interceptedRequest = DeleteListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteListenerResponse> transformer = DeleteListenerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteListenerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteListenerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteListenerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteNetworkLoadBalancerResponse deleteNetworkLoadBalancer(DeleteNetworkLoadBalancerRequest request) {
        LOG.trace("Called deleteNetworkLoadBalancer");
        DeleteNetworkLoadBalancerRequest interceptedRequest = DeleteNetworkLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNetworkLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteNetworkLoadBalancerResponse> transformer = DeleteNetworkLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteNetworkLoadBalancerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteNetworkLoadBalancerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteNetworkLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackendResponse getBackend(GetBackendRequest request) {
        LOG.trace("Called getBackend");
        GetBackendRequest interceptedRequest = GetBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendResponse> transformer = GetBackendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBackendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBackendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBackendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackendHealthResponse getBackendHealth(GetBackendHealthRequest request) {
        LOG.trace("Called getBackendHealth");
        GetBackendHealthRequest interceptedRequest = GetBackendHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendHealthConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendHealthResponse> transformer = GetBackendHealthConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBackendHealthResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBackendHealthResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBackendHealthResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackendSetResponse getBackendSet(GetBackendSetRequest request) {
        LOG.trace("Called getBackendSet");
        GetBackendSetRequest interceptedRequest = GetBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendSetResponse> transformer = GetBackendSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBackendSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBackendSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBackendSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackendSetHealthResponse getBackendSetHealth(GetBackendSetHealthRequest request) {
        LOG.trace("Called getBackendSetHealth");
        GetBackendSetHealthRequest interceptedRequest = GetBackendSetHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendSetHealthConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendSetHealthResponse> transformer = GetBackendSetHealthConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBackendSetHealthResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBackendSetHealthResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBackendSetHealthResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetHealthCheckerResponse getHealthChecker(GetHealthCheckerRequest request) {
        LOG.trace("Called getHealthChecker");
        GetHealthCheckerRequest interceptedRequest = GetHealthCheckerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHealthCheckerResponse> transformer = GetHealthCheckerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (GetHealthCheckerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetHealthCheckerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetHealthCheckerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetListenerResponse getListener(GetListenerRequest request) {
        LOG.trace("Called getListener");
        GetListenerRequest interceptedRequest = GetListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetListenerResponse> transformer = GetListenerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetListenerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetListenerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetListenerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetNetworkLoadBalancerResponse getNetworkLoadBalancer(GetNetworkLoadBalancerRequest request) {
        LOG.trace("Called getNetworkLoadBalancer");
        GetNetworkLoadBalancerRequest interceptedRequest = GetNetworkLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNetworkLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNetworkLoadBalancerResponse> transformer = GetNetworkLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetNetworkLoadBalancerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetNetworkLoadBalancerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetNetworkLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetNetworkLoadBalancerHealthResponse getNetworkLoadBalancerHealth(GetNetworkLoadBalancerHealthRequest request) {
        LOG.trace("Called getNetworkLoadBalancerHealth");
        GetNetworkLoadBalancerHealthRequest interceptedRequest = GetNetworkLoadBalancerHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNetworkLoadBalancerHealthConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNetworkLoadBalancerHealthResponse> transformer = GetNetworkLoadBalancerHealthConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetNetworkLoadBalancerHealthResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetNetworkLoadBalancerHealthResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetNetworkLoadBalancerHealthResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBackendSetsResponse listBackendSets(ListBackendSetsRequest request) {
        LOG.trace("Called listBackendSets");
        ListBackendSetsRequest interceptedRequest = ListBackendSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackendSetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBackendSetsResponse> transformer = ListBackendSetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListBackendSetsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBackendSetsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBackendSetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBackendsResponse listBackends(ListBackendsRequest request) {
        LOG.trace("Called listBackends");
        ListBackendsRequest interceptedRequest = ListBackendsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackendsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBackendsResponse> transformer = ListBackendsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListBackendsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBackendsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBackendsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListListenersResponse listListeners(ListListenersRequest request) {
        LOG.trace("Called listListeners");
        ListListenersRequest interceptedRequest = ListListenersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListListenersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListListenersResponse> transformer = ListListenersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListListenersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListListenersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListListenersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNetworkLoadBalancerHealthsResponse listNetworkLoadBalancerHealths(ListNetworkLoadBalancerHealthsRequest request) {
        LOG.trace("Called listNetworkLoadBalancerHealths");
        ListNetworkLoadBalancerHealthsRequest interceptedRequest = ListNetworkLoadBalancerHealthsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkLoadBalancerHealthsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkLoadBalancerHealthsResponse> transformer = ListNetworkLoadBalancerHealthsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListNetworkLoadBalancerHealthsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNetworkLoadBalancerHealthsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNetworkLoadBalancerHealthsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNetworkLoadBalancersResponse listNetworkLoadBalancers(ListNetworkLoadBalancersRequest request) {
        LOG.trace("Called listNetworkLoadBalancers");
        ListNetworkLoadBalancersRequest interceptedRequest = ListNetworkLoadBalancersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkLoadBalancersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkLoadBalancersResponse> transformer = ListNetworkLoadBalancersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListNetworkLoadBalancersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNetworkLoadBalancersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNetworkLoadBalancersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNetworkLoadBalancersPoliciesResponse listNetworkLoadBalancersPolicies(ListNetworkLoadBalancersPoliciesRequest request) {
        LOG.trace("Called listNetworkLoadBalancersPolicies");
        ListNetworkLoadBalancersPoliciesRequest interceptedRequest = ListNetworkLoadBalancersPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkLoadBalancersPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkLoadBalancersPoliciesResponse> transformer = ListNetworkLoadBalancersPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListNetworkLoadBalancersPoliciesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNetworkLoadBalancersPoliciesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNetworkLoadBalancersPoliciesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNetworkLoadBalancersProtocolsResponse listNetworkLoadBalancersProtocols(ListNetworkLoadBalancersProtocolsRequest request) {
        LOG.trace("Called listNetworkLoadBalancersProtocols");
        ListNetworkLoadBalancersProtocolsRequest interceptedRequest = ListNetworkLoadBalancersProtocolsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkLoadBalancersProtocolsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkLoadBalancersProtocolsResponse> transformer = ListNetworkLoadBalancersProtocolsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListNetworkLoadBalancersProtocolsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNetworkLoadBalancersProtocolsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNetworkLoadBalancersProtocolsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBackendResponse updateBackend(UpdateBackendRequest request) {
        LOG.trace("Called updateBackend");
        UpdateBackendRequest interceptedRequest = UpdateBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBackendResponse> transformer = UpdateBackendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateBackendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBackendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBackendDetails(), (BmcRequest)retriedRequest);
                return (UpdateBackendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBackendSetResponse updateBackendSet(UpdateBackendSetRequest request) {
        LOG.trace("Called updateBackendSet");
        UpdateBackendSetRequest interceptedRequest = UpdateBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBackendSetResponse> transformer = UpdateBackendSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateBackendSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBackendSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBackendSetDetails(), (BmcRequest)retriedRequest);
                return (UpdateBackendSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateHealthCheckerResponse updateHealthChecker(UpdateHealthCheckerRequest request) {
        LOG.trace("Called updateHealthChecker");
        UpdateHealthCheckerRequest interceptedRequest = UpdateHealthCheckerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHealthCheckerResponse> transformer = UpdateHealthCheckerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateHealthCheckerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateHealthCheckerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateHealthCheckerDetails(), (BmcRequest)retriedRequest);
                return (UpdateHealthCheckerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateListenerResponse updateListener(UpdateListenerRequest request) {
        LOG.trace("Called updateListener");
        UpdateListenerRequest interceptedRequest = UpdateListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateListenerResponse> transformer = UpdateListenerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateListenerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateListenerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateListenerDetails(), (BmcRequest)retriedRequest);
                return (UpdateListenerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateNetworkLoadBalancerResponse updateNetworkLoadBalancer(UpdateNetworkLoadBalancerRequest request) {
        LOG.trace("Called updateNetworkLoadBalancer");
        UpdateNetworkLoadBalancerRequest interceptedRequest = UpdateNetworkLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNetworkLoadBalancerResponse> transformer = UpdateNetworkLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateNetworkLoadBalancerResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateNetworkLoadBalancerResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateNetworkLoadBalancerDetails(), (BmcRequest)retriedRequest);
                return (UpdateNetworkLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateNetworkSecurityGroupsResponse updateNetworkSecurityGroups(UpdateNetworkSecurityGroupsRequest request) {
        LOG.trace("Called updateNetworkSecurityGroups");
        UpdateNetworkSecurityGroupsRequest interceptedRequest = UpdateNetworkSecurityGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkSecurityGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNetworkSecurityGroupsResponse> transformer = UpdateNetworkSecurityGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateNetworkSecurityGroupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateNetworkSecurityGroupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateNetworkSecurityGroupsDetails(), (BmcRequest)retriedRequest);
                return (UpdateNetworkSecurityGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public NetworkLoadBalancerWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public NetworkLoadBalancerPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NetworkLoadBalancerClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public NetworkLoadBalancerClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new NetworkLoadBalancerClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

