/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.networkloadbalancer.NetworkLoadBalancer;
import com.oracle.bmc.networkloadbalancer.model.LifecycleState;
import com.oracle.bmc.networkloadbalancer.requests.GetNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetWorkRequestRequest;
import com.oracle.bmc.networkloadbalancer.responses.GetNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class NetworkLoadBalancerWaiters {
    private final ExecutorService executorService;
    private final NetworkLoadBalancer client;

    public Waiter<GetNetworkLoadBalancerRequest, GetNetworkLoadBalancerResponse> forNetworkLoadBalancer(GetNetworkLoadBalancerRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNetworkLoadBalancer(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNetworkLoadBalancerRequest, GetNetworkLoadBalancerResponse> forNetworkLoadBalancer(GetNetworkLoadBalancerRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNetworkLoadBalancer(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNetworkLoadBalancerRequest, GetNetworkLoadBalancerResponse> forNetworkLoadBalancer(GetNetworkLoadBalancerRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNetworkLoadBalancer(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNetworkLoadBalancerRequest, GetNetworkLoadBalancerResponse> forNetworkLoadBalancer(BmcGenericWaiter waiter, GetNetworkLoadBalancerRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetNetworkLoadBalancerRequest, GetNetworkLoadBalancerResponse>(){

            public GetNetworkLoadBalancerResponse apply(GetNetworkLoadBalancerRequest request) {
                return NetworkLoadBalancerWaiters.this.client.getNetworkLoadBalancer(request);
            }
        }, (Predicate)new Predicate<GetNetworkLoadBalancerResponse>(){

            public boolean apply(GetNetworkLoadBalancerResponse response) {
                return targetStatesSet.contains((Object)response.getNetworkLoadBalancer().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return NetworkLoadBalancerWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public NetworkLoadBalancerWaiters(ExecutorService executorService, NetworkLoadBalancer client) {
        this.executorService = executorService;
        this.client = client;
    }
}

