/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.networkloadbalancer.model.NetworkLoadBalancersPolicyCollection;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersPoliciesRequest;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersPoliciesResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListNetworkLoadBalancersPoliciesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListNetworkLoadBalancersPoliciesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListNetworkLoadBalancersPoliciesRequest interceptRequest(ListNetworkLoadBalancersPoliciesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListNetworkLoadBalancersPoliciesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200501").path("networkLoadBalancersPolicies");
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListNetworkLoadBalancersPoliciesResponse> fromResponse() {
        Function<Response, ListNetworkLoadBalancersPoliciesResponse> transformer = new Function<Response, ListNetworkLoadBalancersPoliciesResponse>(){

            public ListNetworkLoadBalancersPoliciesResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersPoliciesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(NetworkLoadBalancersPolicyCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListNetworkLoadBalancersPoliciesResponse.Builder builder = ListNetworkLoadBalancersPoliciesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.networkLoadBalancersPolicyCollection((NetworkLoadBalancersPolicyCollection)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListNetworkLoadBalancersPoliciesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

