/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteBackendRequest
extends BmcRequest<Void> {
    private String networkLoadBalancerId;
    private String backendSetName;
    private String backendName;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"networkLoadBalancerId", "backendSetName", "backendName", "opcRequestId", "ifMatch"})
    DeleteBackendRequest(String networkLoadBalancerId, String backendSetName, String backendName, String opcRequestId, String ifMatch) {
        this.networkLoadBalancerId = networkLoadBalancerId;
        this.backendSetName = backendSetName;
        this.backendName = backendName;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNetworkLoadBalancerId() {
        return this.networkLoadBalancerId;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getBackendName() {
        return this.backendName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteBackendRequest, Void> {
        private String networkLoadBalancerId;
        private String backendSetName;
        private String backendName;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteBackendRequest o) {
            this.networkLoadBalancerId(o.getNetworkLoadBalancerId());
            this.backendSetName(o.getBackendSetName());
            this.backendName(o.getBackendName());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteBackendRequest build() {
            DeleteBackendRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder networkLoadBalancerId(String networkLoadBalancerId) {
            this.networkLoadBalancerId = networkLoadBalancerId;
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            return this;
        }

        public Builder backendName(String backendName) {
            this.backendName = backendName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteBackendRequest buildWithoutInvocationCallback() {
            return new DeleteBackendRequest(this.networkLoadBalancerId, this.backendSetName, this.backendName, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "DeleteBackendRequest.Builder(networkLoadBalancerId=" + this.networkLoadBalancerId + ", backendSetName=" + this.backendSetName + ", backendName=" + this.backendName + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

