/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetNetworkLoadBalancerRequest
extends BmcRequest<Void> {
    private String networkLoadBalancerId;
    private String ifNoneMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"networkLoadBalancerId", "ifNoneMatch", "opcRequestId"})
    GetNetworkLoadBalancerRequest(String networkLoadBalancerId, String ifNoneMatch, String opcRequestId) {
        this.networkLoadBalancerId = networkLoadBalancerId;
        this.ifNoneMatch = ifNoneMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNetworkLoadBalancerId() {
        return this.networkLoadBalancerId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNetworkLoadBalancerRequest, Void> {
        private String networkLoadBalancerId;
        private String ifNoneMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNetworkLoadBalancerRequest o) {
            this.networkLoadBalancerId(o.getNetworkLoadBalancerId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNetworkLoadBalancerRequest build() {
            GetNetworkLoadBalancerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder networkLoadBalancerId(String networkLoadBalancerId) {
            this.networkLoadBalancerId = networkLoadBalancerId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetNetworkLoadBalancerRequest buildWithoutInvocationCallback() {
            return new GetNetworkLoadBalancerRequest(this.networkLoadBalancerId, this.ifNoneMatch, this.opcRequestId);
        }

        public String toString() {
            return "GetNetworkLoadBalancerRequest.Builder(networkLoadBalancerId=" + this.networkLoadBalancerId + ", ifNoneMatch=" + this.ifNoneMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

