/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.networkloadbalancer.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListBackendsRequest
extends BmcRequest<Void> {
    private String networkLoadBalancerId;
    private String backendSetName;
    private String opcRequestId;
    private String ifNoneMatch;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"networkLoadBalancerId", "backendSetName", "opcRequestId", "ifNoneMatch", "limit", "page", "sortOrder"})
    ListBackendsRequest(String networkLoadBalancerId, String backendSetName, String opcRequestId, String ifNoneMatch, Integer limit, String page, SortOrder sortOrder) {
        this.networkLoadBalancerId = networkLoadBalancerId;
        this.backendSetName = backendSetName;
        this.opcRequestId = opcRequestId;
        this.ifNoneMatch = ifNoneMatch;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNetworkLoadBalancerId() {
        return this.networkLoadBalancerId;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListBackendsRequest, Void> {
        private String networkLoadBalancerId;
        private String backendSetName;
        private String opcRequestId;
        private String ifNoneMatch;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBackendsRequest o) {
            this.networkLoadBalancerId(o.getNetworkLoadBalancerId());
            this.backendSetName(o.getBackendSetName());
            this.opcRequestId(o.getOpcRequestId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBackendsRequest build() {
            ListBackendsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder networkLoadBalancerId(String networkLoadBalancerId) {
            this.networkLoadBalancerId = networkLoadBalancerId;
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListBackendsRequest buildWithoutInvocationCallback() {
            return new ListBackendsRequest(this.networkLoadBalancerId, this.backendSetName, this.opcRequestId, this.ifNoneMatch, this.limit, this.page, this.sortOrder);
        }

        public String toString() {
            return "ListBackendsRequest.Builder(networkLoadBalancerId=" + this.networkLoadBalancerId + ", backendSetName=" + this.backendSetName + ", opcRequestId=" + this.opcRequestId + ", ifNoneMatch=" + this.ifNoneMatch + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }
}

