/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.nosql.Nosql;
import com.oracle.bmc.nosql.model.IndexSummary;
import com.oracle.bmc.nosql.model.TableSummary;
import com.oracle.bmc.nosql.model.TableUsageSummary;
import com.oracle.bmc.nosql.model.WorkRequestError;
import com.oracle.bmc.nosql.model.WorkRequestLogEntry;
import com.oracle.bmc.nosql.model.WorkRequestSummary;
import com.oracle.bmc.nosql.requests.ListIndexesRequest;
import com.oracle.bmc.nosql.requests.ListTableUsageRequest;
import com.oracle.bmc.nosql.requests.ListTablesRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestsRequest;
import com.oracle.bmc.nosql.responses.ListIndexesResponse;
import com.oracle.bmc.nosql.responses.ListTableUsageResponse;
import com.oracle.bmc.nosql.responses.ListTablesResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class NosqlPaginators {
    private final Nosql client;

    public Iterable<ListIndexesResponse> listIndexesResponseIterator(final ListIndexesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIndexesRequest.Builder>(){

            public ListIndexesRequest.Builder get() {
                return ListIndexesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIndexesResponse, String>(){

            public String apply(ListIndexesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIndexesRequest.Builder>, ListIndexesRequest>(){

            public ListIndexesRequest apply(RequestBuilderAndToken<ListIndexesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIndexesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIndexesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIndexesRequest, ListIndexesResponse>(){

            public ListIndexesResponse apply(ListIndexesRequest request) {
                return NosqlPaginators.this.client.listIndexes(request);
            }
        });
    }

    public Iterable<IndexSummary> listIndexesRecordIterator(final ListIndexesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIndexesRequest.Builder>(){

            public ListIndexesRequest.Builder get() {
                return ListIndexesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIndexesResponse, String>(){

            public String apply(ListIndexesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIndexesRequest.Builder>, ListIndexesRequest>(){

            public ListIndexesRequest apply(RequestBuilderAndToken<ListIndexesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListIndexesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIndexesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListIndexesRequest, ListIndexesResponse>(){

            public ListIndexesResponse apply(ListIndexesRequest request) {
                return NosqlPaginators.this.client.listIndexes(request);
            }
        }, (Function)new Function<ListIndexesResponse, List<IndexSummary>>(){

            public List<IndexSummary> apply(ListIndexesResponse response) {
                return response.getIndexCollection().getItems();
            }
        });
    }

    public Iterable<ListTableUsageResponse> listTableUsageResponseIterator(final ListTableUsageRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTableUsageRequest.Builder>(){

            public ListTableUsageRequest.Builder get() {
                return ListTableUsageRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTableUsageResponse, String>(){

            public String apply(ListTableUsageResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTableUsageRequest.Builder>, ListTableUsageRequest>(){

            public ListTableUsageRequest apply(RequestBuilderAndToken<ListTableUsageRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTableUsageRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTableUsageRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTableUsageRequest, ListTableUsageResponse>(){

            public ListTableUsageResponse apply(ListTableUsageRequest request) {
                return NosqlPaginators.this.client.listTableUsage(request);
            }
        });
    }

    public Iterable<TableUsageSummary> listTableUsageRecordIterator(final ListTableUsageRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTableUsageRequest.Builder>(){

            public ListTableUsageRequest.Builder get() {
                return ListTableUsageRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTableUsageResponse, String>(){

            public String apply(ListTableUsageResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTableUsageRequest.Builder>, ListTableUsageRequest>(){

            public ListTableUsageRequest apply(RequestBuilderAndToken<ListTableUsageRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTableUsageRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTableUsageRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTableUsageRequest, ListTableUsageResponse>(){

            public ListTableUsageResponse apply(ListTableUsageRequest request) {
                return NosqlPaginators.this.client.listTableUsage(request);
            }
        }, (Function)new Function<ListTableUsageResponse, List<TableUsageSummary>>(){

            public List<TableUsageSummary> apply(ListTableUsageResponse response) {
                return response.getTableUsageCollection().getItems();
            }
        });
    }

    public Iterable<ListTablesResponse> listTablesResponseIterator(final ListTablesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTablesRequest.Builder>(){

            public ListTablesRequest.Builder get() {
                return ListTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTablesResponse, String>(){

            public String apply(ListTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTablesRequest.Builder>, ListTablesRequest>(){

            public ListTablesRequest apply(RequestBuilderAndToken<ListTablesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTablesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTablesRequest, ListTablesResponse>(){

            public ListTablesResponse apply(ListTablesRequest request) {
                return NosqlPaginators.this.client.listTables(request);
            }
        });
    }

    public Iterable<TableSummary> listTablesRecordIterator(final ListTablesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTablesRequest.Builder>(){

            public ListTablesRequest.Builder get() {
                return ListTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTablesResponse, String>(){

            public String apply(ListTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTablesRequest.Builder>, ListTablesRequest>(){

            public ListTablesRequest apply(RequestBuilderAndToken<ListTablesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTablesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTablesRequest, ListTablesResponse>(){

            public ListTablesResponse apply(ListTablesRequest request) {
                return NosqlPaginators.this.client.listTables(request);
            }
        }, (Function)new Function<ListTablesResponse, List<TableSummary>>(){

            public List<TableSummary> apply(ListTablesResponse response) {
                return response.getTableCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return NosqlPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return NosqlPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return NosqlPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return NosqlPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return NosqlPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return NosqlPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public NosqlPaginators(Nosql client) {
        this.client = client;
    }
}

