/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.nosql.model.DeleteRowResult;
import com.oracle.bmc.nosql.requests.DeleteRowRequest;
import com.oracle.bmc.nosql.responses.DeleteRowResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteRowConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteRowConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteRowRequest interceptRequest(DeleteRowRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteRowRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notNull(request.getKey(), (String)"key is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190828").path("tables").path(HttpUtils.encodePathSegment((String)request.getTableNameOrId())).path("rows");
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"key", request.getKey(), (CollectionFormatType)CollectionFormatType.Multi);
        if (request.getIsGetReturnRow() != null) {
            target = target.queryParam("isGetReturnRow", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsGetReturnRow())});
        }
        if (request.getTimeoutInMs() != null) {
            target = target.queryParam("timeoutInMs", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeoutInMs())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, DeleteRowResponse> fromResponse() {
        Function<Response, DeleteRowResponse> transformer = new Function<Response, DeleteRowResponse>(){

            public DeleteRowResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.nosql.responses.DeleteRowResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DeleteRowResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteRowResponse.Builder builder = DeleteRowResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.deleteRowResult((DeleteRowResult)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                DeleteRowResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

