/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.ws.rs.client.Invocation;

public class ListTableUsageRequest
extends BmcRequest<Void> {
    private String tableNameOrId;
    private String compartmentId;
    private String opcRequestId;
    private Date timeStart;
    private Date timeEnd;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"tableNameOrId", "compartmentId", "opcRequestId", "timeStart", "timeEnd", "limit", "page"})
    ListTableUsageRequest(String tableNameOrId, String compartmentId, String opcRequestId, Date timeStart, Date timeEnd, Integer limit, String page) {
        this.tableNameOrId = tableNameOrId;
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTableNameOrId() {
        return this.tableNameOrId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTableUsageRequest, Void> {
        private String tableNameOrId;
        private String compartmentId;
        private String opcRequestId;
        private Date timeStart;
        private Date timeEnd;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTableUsageRequest o) {
            this.tableNameOrId(o.getTableNameOrId());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTableUsageRequest build() {
            ListTableUsageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tableNameOrId(String tableNameOrId) {
            this.tableNameOrId = tableNameOrId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListTableUsageRequest buildWithoutInvocationCallback() {
            return new ListTableUsageRequest(this.tableNameOrId, this.compartmentId, this.opcRequestId, this.timeStart, this.timeEnd, this.limit, this.page);
        }

        public String toString() {
            return "ListTableUsageRequest.Builder(tableNameOrId=" + this.tableNameOrId + ", compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", timeStart=" + this.timeStart + ", timeEnd=" + this.timeEnd + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

