/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.model.ListObjects;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListObjectsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListObjectsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListObjectsRequest interceptRequest(ListObjectsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListObjectsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment((String)request.getBucketName())).path("o");
        if (request.getPrefix() != null) {
            target = target.queryParam("prefix", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPrefix())});
        }
        if (request.getStart() != null) {
            target = target.queryParam("start", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStart())});
        }
        if (request.getEnd() != null) {
            target = target.queryParam("end", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getEnd())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getDelimiter() != null) {
            target = target.queryParam("delimiter", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDelimiter())});
        }
        if (request.getFields() != null) {
            target = target.queryParam("fields", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getFields())});
        }
        if (request.getStartAfter() != null) {
            target = target.queryParam("startAfter", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStartAfter())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", (Object)request.getOpcClientRequestId());
        }
        return ib;
    }

    public static Function<Response, ListObjectsResponse> fromResponse() {
        Function<Response, ListObjectsResponse> transformer = new Function<Response, ListObjectsResponse>(){

            public ListObjectsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.objectstorage.responses.ListObjectsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ListObjects.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListObjectsResponse.Builder builder = ListObjectsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.listObjects((ListObjects)response.getItem());
                Optional opcClientRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId((String)HeaderUtils.toValue((String)"opc-client-request-id", (String)((String)((List)opcClientRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListObjectsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

