/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetBucketRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private String ifMatch;
    private String ifNoneMatch;
    private String opcClientRequestId;
    private List<Fields> fields;

    @ConstructorProperties(value={"namespaceName", "bucketName", "ifMatch", "ifNoneMatch", "opcClientRequestId", "fields"})
    GetBucketRequest(String namespaceName, String bucketName, String ifMatch, String ifNoneMatch, String opcClientRequestId, List<Fields> fields) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.ifMatch = ifMatch;
        this.ifNoneMatch = ifNoneMatch;
        this.opcClientRequestId = opcClientRequestId;
        this.fields = fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBucketRequest, Void> {
        private String namespaceName;
        private String bucketName;
        private String ifMatch;
        private String ifNoneMatch;
        private String opcClientRequestId;
        private List<Fields> fields;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBucketRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.ifMatch(o.getIfMatch());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.fields(o.getFields());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBucketRequest build() {
            GetBucketRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public GetBucketRequest buildWithoutInvocationCallback() {
            return new GetBucketRequest(this.namespaceName, this.bucketName, this.ifMatch, this.ifNoneMatch, this.opcClientRequestId, this.fields);
        }

        public String toString() {
            return "GetBucketRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", ifMatch=" + this.ifMatch + ", ifNoneMatch=" + this.ifNoneMatch + ", opcClientRequestId=" + this.opcClientRequestId + ", fields=" + this.fields + ")";
        }
    }

    public static enum Fields {
        ApproximateCount("approximateCount"),
        ApproximateSize("approximateSize");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

