/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.ocvp.Sddc;
import com.oracle.bmc.ocvp.model.SddcSummary;
import com.oracle.bmc.ocvp.model.SupportedVmwareSoftwareVersionSummary;
import com.oracle.bmc.ocvp.requests.ListSddcsRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedVmwareSoftwareVersionsRequest;
import com.oracle.bmc.ocvp.responses.ListSddcsResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedVmwareSoftwareVersionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class SddcPaginators {
    private final Sddc client;

    public Iterable<ListSddcsResponse> listSddcsResponseIterator(final ListSddcsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSddcsRequest.Builder>(){

            public ListSddcsRequest.Builder get() {
                return ListSddcsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSddcsResponse, String>(){

            public String apply(ListSddcsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSddcsRequest.Builder>, ListSddcsRequest>(){

            public ListSddcsRequest apply(RequestBuilderAndToken<ListSddcsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSddcsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSddcsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSddcsRequest, ListSddcsResponse>(){

            public ListSddcsResponse apply(ListSddcsRequest request) {
                return SddcPaginators.this.client.listSddcs(request);
            }
        });
    }

    public Iterable<SddcSummary> listSddcsRecordIterator(final ListSddcsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSddcsRequest.Builder>(){

            public ListSddcsRequest.Builder get() {
                return ListSddcsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSddcsResponse, String>(){

            public String apply(ListSddcsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSddcsRequest.Builder>, ListSddcsRequest>(){

            public ListSddcsRequest apply(RequestBuilderAndToken<ListSddcsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSddcsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSddcsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSddcsRequest, ListSddcsResponse>(){

            public ListSddcsResponse apply(ListSddcsRequest request) {
                return SddcPaginators.this.client.listSddcs(request);
            }
        }, (Function)new Function<ListSddcsResponse, List<SddcSummary>>(){

            public List<SddcSummary> apply(ListSddcsResponse response) {
                return response.getSddcCollection().getItems();
            }
        });
    }

    public Iterable<ListSupportedVmwareSoftwareVersionsResponse> listSupportedVmwareSoftwareVersionsResponseIterator(final ListSupportedVmwareSoftwareVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSupportedVmwareSoftwareVersionsRequest.Builder>(){

            public ListSupportedVmwareSoftwareVersionsRequest.Builder get() {
                return ListSupportedVmwareSoftwareVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsResponse, String>(){

            public String apply(ListSupportedVmwareSoftwareVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSupportedVmwareSoftwareVersionsRequest.Builder>, ListSupportedVmwareSoftwareVersionsRequest>(){

            public ListSupportedVmwareSoftwareVersionsRequest apply(RequestBuilderAndToken<ListSupportedVmwareSoftwareVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSupportedVmwareSoftwareVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSupportedVmwareSoftwareVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsRequest, ListSupportedVmwareSoftwareVersionsResponse>(){

            public ListSupportedVmwareSoftwareVersionsResponse apply(ListSupportedVmwareSoftwareVersionsRequest request) {
                return SddcPaginators.this.client.listSupportedVmwareSoftwareVersions(request);
            }
        });
    }

    public Iterable<SupportedVmwareSoftwareVersionSummary> listSupportedVmwareSoftwareVersionsRecordIterator(final ListSupportedVmwareSoftwareVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSupportedVmwareSoftwareVersionsRequest.Builder>(){

            public ListSupportedVmwareSoftwareVersionsRequest.Builder get() {
                return ListSupportedVmwareSoftwareVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsResponse, String>(){

            public String apply(ListSupportedVmwareSoftwareVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSupportedVmwareSoftwareVersionsRequest.Builder>, ListSupportedVmwareSoftwareVersionsRequest>(){

            public ListSupportedVmwareSoftwareVersionsRequest apply(RequestBuilderAndToken<ListSupportedVmwareSoftwareVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSupportedVmwareSoftwareVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSupportedVmwareSoftwareVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsRequest, ListSupportedVmwareSoftwareVersionsResponse>(){

            public ListSupportedVmwareSoftwareVersionsResponse apply(ListSupportedVmwareSoftwareVersionsRequest request) {
                return SddcPaginators.this.client.listSupportedVmwareSoftwareVersions(request);
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsResponse, List<SupportedVmwareSoftwareVersionSummary>>(){

            public List<SupportedVmwareSoftwareVersionSummary> apply(ListSupportedVmwareSoftwareVersionsResponse response) {
                return response.getSupportedVmwareSoftwareVersionCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public SddcPaginators(Sddc client) {
        this.client = client;
    }
}

