/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.ons.NotificationDataPlane;
import com.oracle.bmc.ons.model.SubscriptionSummary;
import com.oracle.bmc.ons.requests.ListSubscriptionsRequest;
import com.oracle.bmc.ons.responses.ListSubscriptionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class NotificationDataPlanePaginators {
    private final NotificationDataPlane client;

    public Iterable<ListSubscriptionsResponse> listSubscriptionsResponseIterator(final ListSubscriptionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSubscriptionsRequest.Builder>(){

            public ListSubscriptionsRequest.Builder get() {
                return ListSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionsResponse, String>(){

            public String apply(ListSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionsRequest.Builder>, ListSubscriptionsRequest>(){

            public ListSubscriptionsRequest apply(RequestBuilderAndToken<ListSubscriptionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSubscriptionsRequest, ListSubscriptionsResponse>(){

            public ListSubscriptionsResponse apply(ListSubscriptionsRequest request) {
                return NotificationDataPlanePaginators.this.client.listSubscriptions(request);
            }
        });
    }

    public Iterable<SubscriptionSummary> listSubscriptionsRecordIterator(final ListSubscriptionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSubscriptionsRequest.Builder>(){

            public ListSubscriptionsRequest.Builder get() {
                return ListSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionsResponse, String>(){

            public String apply(ListSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionsRequest.Builder>, ListSubscriptionsRequest>(){

            public ListSubscriptionsRequest apply(RequestBuilderAndToken<ListSubscriptionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSubscriptionsRequest, ListSubscriptionsResponse>(){

            public ListSubscriptionsResponse apply(ListSubscriptionsRequest request) {
                return NotificationDataPlanePaginators.this.client.listSubscriptions(request);
            }
        }, (Function)new Function<ListSubscriptionsResponse, List<SubscriptionSummary>>(){

            public List<SubscriptionSummary> apply(ListSubscriptionsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public NotificationDataPlanePaginators(NotificationDataPlane client) {
        this.client = client;
    }
}

