/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.optimizer.Optimizer;
import com.oracle.bmc.optimizer.OptimizerPaginators;
import com.oracle.bmc.optimizer.OptimizerWaiters;
import com.oracle.bmc.optimizer.internal.http.BulkApplyRecommendationsConverter;
import com.oracle.bmc.optimizer.internal.http.CreateProfileConverter;
import com.oracle.bmc.optimizer.internal.http.DeleteProfileConverter;
import com.oracle.bmc.optimizer.internal.http.GetCategoryConverter;
import com.oracle.bmc.optimizer.internal.http.GetEnrollmentStatusConverter;
import com.oracle.bmc.optimizer.internal.http.GetProfileConverter;
import com.oracle.bmc.optimizer.internal.http.GetRecommendationConverter;
import com.oracle.bmc.optimizer.internal.http.GetResourceActionConverter;
import com.oracle.bmc.optimizer.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.optimizer.internal.http.ListCategoriesConverter;
import com.oracle.bmc.optimizer.internal.http.ListEnrollmentStatusesConverter;
import com.oracle.bmc.optimizer.internal.http.ListHistoriesConverter;
import com.oracle.bmc.optimizer.internal.http.ListProfilesConverter;
import com.oracle.bmc.optimizer.internal.http.ListRecommendationStrategiesConverter;
import com.oracle.bmc.optimizer.internal.http.ListRecommendationsConverter;
import com.oracle.bmc.optimizer.internal.http.ListResourceActionsConverter;
import com.oracle.bmc.optimizer.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.optimizer.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.optimizer.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.optimizer.internal.http.UpdateEnrollmentStatusConverter;
import com.oracle.bmc.optimizer.internal.http.UpdateProfileConverter;
import com.oracle.bmc.optimizer.internal.http.UpdateRecommendationConverter;
import com.oracle.bmc.optimizer.internal.http.UpdateResourceActionConverter;
import com.oracle.bmc.optimizer.requests.BulkApplyRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.CreateProfileRequest;
import com.oracle.bmc.optimizer.requests.DeleteProfileRequest;
import com.oracle.bmc.optimizer.requests.GetCategoryRequest;
import com.oracle.bmc.optimizer.requests.GetEnrollmentStatusRequest;
import com.oracle.bmc.optimizer.requests.GetProfileRequest;
import com.oracle.bmc.optimizer.requests.GetRecommendationRequest;
import com.oracle.bmc.optimizer.requests.GetResourceActionRequest;
import com.oracle.bmc.optimizer.requests.GetWorkRequestRequest;
import com.oracle.bmc.optimizer.requests.ListCategoriesRequest;
import com.oracle.bmc.optimizer.requests.ListEnrollmentStatusesRequest;
import com.oracle.bmc.optimizer.requests.ListHistoriesRequest;
import com.oracle.bmc.optimizer.requests.ListProfilesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationStrategiesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.ListResourceActionsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.optimizer.requests.UpdateEnrollmentStatusRequest;
import com.oracle.bmc.optimizer.requests.UpdateProfileRequest;
import com.oracle.bmc.optimizer.requests.UpdateRecommendationRequest;
import com.oracle.bmc.optimizer.requests.UpdateResourceActionRequest;
import com.oracle.bmc.optimizer.responses.BulkApplyRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.CreateProfileResponse;
import com.oracle.bmc.optimizer.responses.DeleteProfileResponse;
import com.oracle.bmc.optimizer.responses.GetCategoryResponse;
import com.oracle.bmc.optimizer.responses.GetEnrollmentStatusResponse;
import com.oracle.bmc.optimizer.responses.GetProfileResponse;
import com.oracle.bmc.optimizer.responses.GetRecommendationResponse;
import com.oracle.bmc.optimizer.responses.GetResourceActionResponse;
import com.oracle.bmc.optimizer.responses.GetWorkRequestResponse;
import com.oracle.bmc.optimizer.responses.ListCategoriesResponse;
import com.oracle.bmc.optimizer.responses.ListEnrollmentStatusesResponse;
import com.oracle.bmc.optimizer.responses.ListHistoriesResponse;
import com.oracle.bmc.optimizer.responses.ListProfilesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationStrategiesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.ListResourceActionsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.optimizer.responses.UpdateEnrollmentStatusResponse;
import com.oracle.bmc.optimizer.responses.UpdateProfileResponse;
import com.oracle.bmc.optimizer.responses.UpdateRecommendationResponse;
import com.oracle.bmc.optimizer.responses.UpdateResourceActionResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerClient
implements Optimizer {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizerClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPTIMIZER").serviceEndpointPrefix("").serviceEndpointTemplate("https://optimizer.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final OptimizerWaiters waiters;
    private final OptimizerPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public OptimizerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OptimizerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OptimizerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Optimizer-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OptimizerWaiters(executorService, this);
        this.paginators = new OptimizerPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public BulkApplyRecommendationsResponse bulkApplyRecommendations(BulkApplyRecommendationsRequest request) {
        LOG.trace("Called bulkApplyRecommendations");
        BulkApplyRecommendationsRequest interceptedRequest = BulkApplyRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkApplyRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BulkApplyRecommendationsResponse> transformer = BulkApplyRecommendationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (BulkApplyRecommendationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BulkApplyRecommendationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBulkApplyRecommendationsDetails(), (BmcRequest)retriedRequest);
                return (BulkApplyRecommendationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateProfileResponse createProfile(CreateProfileRequest request) {
        LOG.trace("Called createProfile");
        CreateProfileRequest interceptedRequest = CreateProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProfileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateProfileResponse> transformer = CreateProfileConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateProfileResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateProfileResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateProfileDetails(), (BmcRequest)retriedRequest);
                return (CreateProfileResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteProfileResponse deleteProfile(DeleteProfileRequest request) {
        LOG.trace("Called deleteProfile");
        DeleteProfileRequest interceptedRequest = DeleteProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProfileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteProfileResponse> transformer = DeleteProfileConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteProfileResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteProfileResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteProfileResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCategoryResponse getCategory(GetCategoryRequest request) {
        LOG.trace("Called getCategory");
        GetCategoryRequest interceptedRequest = GetCategoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCategoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCategoryResponse> transformer = GetCategoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetCategoryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCategoryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCategoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetEnrollmentStatusResponse getEnrollmentStatus(GetEnrollmentStatusRequest request) {
        LOG.trace("Called getEnrollmentStatus");
        GetEnrollmentStatusRequest interceptedRequest = GetEnrollmentStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEnrollmentStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetEnrollmentStatusResponse> transformer = GetEnrollmentStatusConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetEnrollmentStatusResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetEnrollmentStatusResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetEnrollmentStatusResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetProfileResponse getProfile(GetProfileRequest request) {
        LOG.trace("Called getProfile");
        GetProfileRequest interceptedRequest = GetProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProfileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetProfileResponse> transformer = GetProfileConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetProfileResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetProfileResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetProfileResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRecommendationResponse getRecommendation(GetRecommendationRequest request) {
        LOG.trace("Called getRecommendation");
        GetRecommendationRequest interceptedRequest = GetRecommendationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRecommendationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRecommendationResponse> transformer = GetRecommendationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRecommendationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRecommendationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRecommendationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetResourceActionResponse getResourceAction(GetResourceActionRequest request) {
        LOG.trace("Called getResourceAction");
        GetResourceActionRequest interceptedRequest = GetResourceActionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetResourceActionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetResourceActionResponse> transformer = GetResourceActionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetResourceActionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetResourceActionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetResourceActionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCategoriesResponse listCategories(ListCategoriesRequest request) {
        LOG.trace("Called listCategories");
        ListCategoriesRequest interceptedRequest = ListCategoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCategoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCategoriesResponse> transformer = ListCategoriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCategoriesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCategoriesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCategoriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListEnrollmentStatusesResponse listEnrollmentStatuses(ListEnrollmentStatusesRequest request) {
        LOG.trace("Called listEnrollmentStatuses");
        ListEnrollmentStatusesRequest interceptedRequest = ListEnrollmentStatusesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEnrollmentStatusesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListEnrollmentStatusesResponse> transformer = ListEnrollmentStatusesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListEnrollmentStatusesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListEnrollmentStatusesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListEnrollmentStatusesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListHistoriesResponse listHistories(ListHistoriesRequest request) {
        LOG.trace("Called listHistories");
        ListHistoriesRequest interceptedRequest = ListHistoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHistoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHistoriesResponse> transformer = ListHistoriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListHistoriesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListHistoriesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListHistoriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListProfilesResponse listProfiles(ListProfilesRequest request) {
        LOG.trace("Called listProfiles");
        ListProfilesRequest interceptedRequest = ListProfilesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProfilesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProfilesResponse> transformer = ListProfilesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListProfilesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProfilesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProfilesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRecommendationStrategiesResponse listRecommendationStrategies(ListRecommendationStrategiesRequest request) {
        LOG.trace("Called listRecommendationStrategies");
        ListRecommendationStrategiesRequest interceptedRequest = ListRecommendationStrategiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecommendationStrategiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRecommendationStrategiesResponse> transformer = ListRecommendationStrategiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRecommendationStrategiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRecommendationStrategiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRecommendationStrategiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest request) {
        LOG.trace("Called listRecommendations");
        ListRecommendationsRequest interceptedRequest = ListRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRecommendationsResponse> transformer = ListRecommendationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRecommendationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRecommendationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRecommendationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResourceActionsResponse listResourceActions(ListResourceActionsRequest request) {
        LOG.trace("Called listResourceActions");
        ListResourceActionsRequest interceptedRequest = ListResourceActionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResourceActionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResourceActionsResponse> transformer = ListResourceActionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResourceActionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResourceActionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResourceActionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateEnrollmentStatusResponse updateEnrollmentStatus(UpdateEnrollmentStatusRequest request) {
        LOG.trace("Called updateEnrollmentStatus");
        UpdateEnrollmentStatusRequest interceptedRequest = UpdateEnrollmentStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateEnrollmentStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateEnrollmentStatusResponse> transformer = UpdateEnrollmentStatusConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateEnrollmentStatusResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateEnrollmentStatusResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateEnrollmentStatusDetails(), (BmcRequest)retriedRequest);
                return (UpdateEnrollmentStatusResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateProfileResponse updateProfile(UpdateProfileRequest request) {
        LOG.trace("Called updateProfile");
        UpdateProfileRequest interceptedRequest = UpdateProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProfileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateProfileResponse> transformer = UpdateProfileConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateProfileResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateProfileResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateProfileDetails(), (BmcRequest)retriedRequest);
                return (UpdateProfileResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRecommendationResponse updateRecommendation(UpdateRecommendationRequest request) {
        LOG.trace("Called updateRecommendation");
        UpdateRecommendationRequest interceptedRequest = UpdateRecommendationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRecommendationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRecommendationResponse> transformer = UpdateRecommendationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateRecommendationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRecommendationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRecommendationDetails(), (BmcRequest)retriedRequest);
                return (UpdateRecommendationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateResourceActionResponse updateResourceAction(UpdateResourceActionRequest request) {
        LOG.trace("Called updateResourceAction");
        UpdateResourceActionRequest interceptedRequest = UpdateResourceActionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateResourceActionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateResourceActionResponse> transformer = UpdateResourceActionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateResourceActionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateResourceActionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateResourceActionDetails(), (BmcRequest)retriedRequest);
                return (UpdateResourceActionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public OptimizerWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OptimizerPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OptimizerClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OptimizerClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new OptimizerClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

