/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.optimizer.Optimizer;
import com.oracle.bmc.optimizer.model.CategorySummary;
import com.oracle.bmc.optimizer.model.EnrollmentStatusSummary;
import com.oracle.bmc.optimizer.model.HistorySummary;
import com.oracle.bmc.optimizer.model.ProfileSummary;
import com.oracle.bmc.optimizer.model.RecommendationStrategySummary;
import com.oracle.bmc.optimizer.model.RecommendationSummary;
import com.oracle.bmc.optimizer.model.ResourceActionSummary;
import com.oracle.bmc.optimizer.model.WorkRequest;
import com.oracle.bmc.optimizer.model.WorkRequestError;
import com.oracle.bmc.optimizer.model.WorkRequestLogEntry;
import com.oracle.bmc.optimizer.requests.ListCategoriesRequest;
import com.oracle.bmc.optimizer.requests.ListEnrollmentStatusesRequest;
import com.oracle.bmc.optimizer.requests.ListHistoriesRequest;
import com.oracle.bmc.optimizer.requests.ListProfilesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationStrategiesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.ListResourceActionsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.optimizer.responses.ListCategoriesResponse;
import com.oracle.bmc.optimizer.responses.ListEnrollmentStatusesResponse;
import com.oracle.bmc.optimizer.responses.ListHistoriesResponse;
import com.oracle.bmc.optimizer.responses.ListProfilesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationStrategiesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.ListResourceActionsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class OptimizerPaginators {
    private final Optimizer client;

    public Iterable<ListCategoriesResponse> listCategoriesResponseIterator(final ListCategoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCategoriesRequest.Builder>(){

            public ListCategoriesRequest.Builder get() {
                return ListCategoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCategoriesResponse, String>(){

            public String apply(ListCategoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCategoriesRequest.Builder>, ListCategoriesRequest>(){

            public ListCategoriesRequest apply(RequestBuilderAndToken<ListCategoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListCategoriesRequest, ListCategoriesResponse>(){

            public ListCategoriesResponse apply(ListCategoriesRequest request) {
                return OptimizerPaginators.this.client.listCategories(request);
            }
        });
    }

    public Iterable<CategorySummary> listCategoriesRecordIterator(final ListCategoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCategoriesRequest.Builder>(){

            public ListCategoriesRequest.Builder get() {
                return ListCategoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCategoriesResponse, String>(){

            public String apply(ListCategoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCategoriesRequest.Builder>, ListCategoriesRequest>(){

            public ListCategoriesRequest apply(RequestBuilderAndToken<ListCategoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCategoriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListCategoriesRequest, ListCategoriesResponse>(){

            public ListCategoriesResponse apply(ListCategoriesRequest request) {
                return OptimizerPaginators.this.client.listCategories(request);
            }
        }, (Function)new Function<ListCategoriesResponse, List<CategorySummary>>(){

            public List<CategorySummary> apply(ListCategoriesResponse response) {
                return response.getCategoryCollection().getItems();
            }
        });
    }

    public Iterable<ListEnrollmentStatusesResponse> listEnrollmentStatusesResponseIterator(final ListEnrollmentStatusesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEnrollmentStatusesRequest.Builder>(){

            public ListEnrollmentStatusesRequest.Builder get() {
                return ListEnrollmentStatusesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEnrollmentStatusesResponse, String>(){

            public String apply(ListEnrollmentStatusesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEnrollmentStatusesRequest.Builder>, ListEnrollmentStatusesRequest>(){

            public ListEnrollmentStatusesRequest apply(RequestBuilderAndToken<ListEnrollmentStatusesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListEnrollmentStatusesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEnrollmentStatusesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListEnrollmentStatusesRequest, ListEnrollmentStatusesResponse>(){

            public ListEnrollmentStatusesResponse apply(ListEnrollmentStatusesRequest request) {
                return OptimizerPaginators.this.client.listEnrollmentStatuses(request);
            }
        });
    }

    public Iterable<EnrollmentStatusSummary> listEnrollmentStatusesRecordIterator(final ListEnrollmentStatusesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEnrollmentStatusesRequest.Builder>(){

            public ListEnrollmentStatusesRequest.Builder get() {
                return ListEnrollmentStatusesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEnrollmentStatusesResponse, String>(){

            public String apply(ListEnrollmentStatusesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEnrollmentStatusesRequest.Builder>, ListEnrollmentStatusesRequest>(){

            public ListEnrollmentStatusesRequest apply(RequestBuilderAndToken<ListEnrollmentStatusesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListEnrollmentStatusesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEnrollmentStatusesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListEnrollmentStatusesRequest, ListEnrollmentStatusesResponse>(){

            public ListEnrollmentStatusesResponse apply(ListEnrollmentStatusesRequest request) {
                return OptimizerPaginators.this.client.listEnrollmentStatuses(request);
            }
        }, (Function)new Function<ListEnrollmentStatusesResponse, List<EnrollmentStatusSummary>>(){

            public List<EnrollmentStatusSummary> apply(ListEnrollmentStatusesResponse response) {
                return response.getEnrollmentStatusCollection().getItems();
            }
        });
    }

    public Iterable<ListHistoriesResponse> listHistoriesResponseIterator(final ListHistoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHistoriesRequest.Builder>(){

            public ListHistoriesRequest.Builder get() {
                return ListHistoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHistoriesResponse, String>(){

            public String apply(ListHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHistoriesRequest.Builder>, ListHistoriesRequest>(){

            public ListHistoriesRequest apply(RequestBuilderAndToken<ListHistoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHistoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHistoriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHistoriesRequest, ListHistoriesResponse>(){

            public ListHistoriesResponse apply(ListHistoriesRequest request) {
                return OptimizerPaginators.this.client.listHistories(request);
            }
        });
    }

    public Iterable<HistorySummary> listHistoriesRecordIterator(final ListHistoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHistoriesRequest.Builder>(){

            public ListHistoriesRequest.Builder get() {
                return ListHistoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHistoriesResponse, String>(){

            public String apply(ListHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHistoriesRequest.Builder>, ListHistoriesRequest>(){

            public ListHistoriesRequest apply(RequestBuilderAndToken<ListHistoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHistoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHistoriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHistoriesRequest, ListHistoriesResponse>(){

            public ListHistoriesResponse apply(ListHistoriesRequest request) {
                return OptimizerPaginators.this.client.listHistories(request);
            }
        }, (Function)new Function<ListHistoriesResponse, List<HistorySummary>>(){

            public List<HistorySummary> apply(ListHistoriesResponse response) {
                return response.getHistoryCollection().getItems();
            }
        });
    }

    public Iterable<ListProfilesResponse> listProfilesResponseIterator(final ListProfilesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProfilesRequest.Builder>(){

            public ListProfilesRequest.Builder get() {
                return ListProfilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProfilesResponse, String>(){

            public String apply(ListProfilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProfilesRequest.Builder>, ListProfilesRequest>(){

            public ListProfilesRequest apply(RequestBuilderAndToken<ListProfilesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListProfilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProfilesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListProfilesRequest, ListProfilesResponse>(){

            public ListProfilesResponse apply(ListProfilesRequest request) {
                return OptimizerPaginators.this.client.listProfiles(request);
            }
        });
    }

    public Iterable<ProfileSummary> listProfilesRecordIterator(final ListProfilesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProfilesRequest.Builder>(){

            public ListProfilesRequest.Builder get() {
                return ListProfilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProfilesResponse, String>(){

            public String apply(ListProfilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProfilesRequest.Builder>, ListProfilesRequest>(){

            public ListProfilesRequest apply(RequestBuilderAndToken<ListProfilesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListProfilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProfilesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListProfilesRequest, ListProfilesResponse>(){

            public ListProfilesResponse apply(ListProfilesRequest request) {
                return OptimizerPaginators.this.client.listProfiles(request);
            }
        }, (Function)new Function<ListProfilesResponse, List<ProfileSummary>>(){

            public List<ProfileSummary> apply(ListProfilesResponse response) {
                return response.getProfileCollection().getItems();
            }
        });
    }

    public Iterable<ListRecommendationStrategiesResponse> listRecommendationStrategiesResponseIterator(final ListRecommendationStrategiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRecommendationStrategiesRequest.Builder>(){

            public ListRecommendationStrategiesRequest.Builder get() {
                return ListRecommendationStrategiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecommendationStrategiesResponse, String>(){

            public String apply(ListRecommendationStrategiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecommendationStrategiesRequest.Builder>, ListRecommendationStrategiesRequest>(){

            public ListRecommendationStrategiesRequest apply(RequestBuilderAndToken<ListRecommendationStrategiesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRecommendationStrategiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecommendationStrategiesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRecommendationStrategiesRequest, ListRecommendationStrategiesResponse>(){

            public ListRecommendationStrategiesResponse apply(ListRecommendationStrategiesRequest request) {
                return OptimizerPaginators.this.client.listRecommendationStrategies(request);
            }
        });
    }

    public Iterable<RecommendationStrategySummary> listRecommendationStrategiesRecordIterator(final ListRecommendationStrategiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRecommendationStrategiesRequest.Builder>(){

            public ListRecommendationStrategiesRequest.Builder get() {
                return ListRecommendationStrategiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecommendationStrategiesResponse, String>(){

            public String apply(ListRecommendationStrategiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecommendationStrategiesRequest.Builder>, ListRecommendationStrategiesRequest>(){

            public ListRecommendationStrategiesRequest apply(RequestBuilderAndToken<ListRecommendationStrategiesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRecommendationStrategiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecommendationStrategiesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRecommendationStrategiesRequest, ListRecommendationStrategiesResponse>(){

            public ListRecommendationStrategiesResponse apply(ListRecommendationStrategiesRequest request) {
                return OptimizerPaginators.this.client.listRecommendationStrategies(request);
            }
        }, (Function)new Function<ListRecommendationStrategiesResponse, List<RecommendationStrategySummary>>(){

            public List<RecommendationStrategySummary> apply(ListRecommendationStrategiesResponse response) {
                return response.getRecommendationStrategyCollection().getItems();
            }
        });
    }

    public Iterable<ListRecommendationsResponse> listRecommendationsResponseIterator(final ListRecommendationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRecommendationsRequest.Builder>(){

            public ListRecommendationsRequest.Builder get() {
                return ListRecommendationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecommendationsResponse, String>(){

            public String apply(ListRecommendationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecommendationsRequest.Builder>, ListRecommendationsRequest>(){

            public ListRecommendationsRequest apply(RequestBuilderAndToken<ListRecommendationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRecommendationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecommendationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRecommendationsRequest, ListRecommendationsResponse>(){

            public ListRecommendationsResponse apply(ListRecommendationsRequest request) {
                return OptimizerPaginators.this.client.listRecommendations(request);
            }
        });
    }

    public Iterable<RecommendationSummary> listRecommendationsRecordIterator(final ListRecommendationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRecommendationsRequest.Builder>(){

            public ListRecommendationsRequest.Builder get() {
                return ListRecommendationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecommendationsResponse, String>(){

            public String apply(ListRecommendationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecommendationsRequest.Builder>, ListRecommendationsRequest>(){

            public ListRecommendationsRequest apply(RequestBuilderAndToken<ListRecommendationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRecommendationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecommendationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRecommendationsRequest, ListRecommendationsResponse>(){

            public ListRecommendationsResponse apply(ListRecommendationsRequest request) {
                return OptimizerPaginators.this.client.listRecommendations(request);
            }
        }, (Function)new Function<ListRecommendationsResponse, List<RecommendationSummary>>(){

            public List<RecommendationSummary> apply(ListRecommendationsResponse response) {
                return response.getRecommendationCollection().getItems();
            }
        });
    }

    public Iterable<ListResourceActionsResponse> listResourceActionsResponseIterator(final ListResourceActionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResourceActionsRequest.Builder>(){

            public ListResourceActionsRequest.Builder get() {
                return ListResourceActionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceActionsResponse, String>(){

            public String apply(ListResourceActionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceActionsRequest.Builder>, ListResourceActionsRequest>(){

            public ListResourceActionsRequest apply(RequestBuilderAndToken<ListResourceActionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListResourceActionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceActionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListResourceActionsRequest, ListResourceActionsResponse>(){

            public ListResourceActionsResponse apply(ListResourceActionsRequest request) {
                return OptimizerPaginators.this.client.listResourceActions(request);
            }
        });
    }

    public Iterable<ResourceActionSummary> listResourceActionsRecordIterator(final ListResourceActionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResourceActionsRequest.Builder>(){

            public ListResourceActionsRequest.Builder get() {
                return ListResourceActionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceActionsResponse, String>(){

            public String apply(ListResourceActionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceActionsRequest.Builder>, ListResourceActionsRequest>(){

            public ListResourceActionsRequest apply(RequestBuilderAndToken<ListResourceActionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListResourceActionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceActionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListResourceActionsRequest, ListResourceActionsResponse>(){

            public ListResourceActionsResponse apply(ListResourceActionsRequest request) {
                return OptimizerPaginators.this.client.listResourceActions(request);
            }
        }, (Function)new Function<ListResourceActionsResponse, List<ResourceActionSummary>>(){

            public List<ResourceActionSummary> apply(ListResourceActionsResponse response) {
                return response.getResourceActionCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OptimizerPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public OptimizerPaginators(Optimizer client) {
        this.client = client;
    }
}

