/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.optimizer.model.EnrollmentStatusCollection;
import com.oracle.bmc.optimizer.requests.ListEnrollmentStatusesRequest;
import com.oracle.bmc.optimizer.responses.ListEnrollmentStatusesResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListEnrollmentStatusesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListEnrollmentStatusesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListEnrollmentStatusesRequest interceptRequest(ListEnrollmentStatusesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListEnrollmentStatusesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200606").path("enrollmentStatus");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getStatus() != null) {
            target = target.queryParam("status", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStatus().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListEnrollmentStatusesResponse> fromResponse() {
        Function<Response, ListEnrollmentStatusesResponse> transformer = new Function<Response, ListEnrollmentStatusesResponse>(){

            public ListEnrollmentStatusesResponse apply(Response rawResponse) {
                Optional opcPrevPageHeader;
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.optimizer.responses.ListEnrollmentStatusesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(EnrollmentStatusCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListEnrollmentStatusesResponse.Builder builder = ListEnrollmentStatusesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.enrollmentStatusCollection((EnrollmentStatusCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcPrevPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-prev-page")).isPresent()) {
                    builder.opcPrevPage((String)HeaderUtils.toValue((String)"opc-prev-page", (String)((String)((List)opcPrevPageHeader.get()).get(0)), String.class));
                }
                ListEnrollmentStatusesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

