/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagement.model.IsEligibleForInstallation;
import com.oracle.bmc.osmanagement.model.UpdateTypes;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WindowsUpdate {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="updateType")
    private final UpdateTypes updateType;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="isEligibleForInstallation")
    private final IsEligibleForInstallation isEligibleForInstallation;
    @JsonProperty(value="installationRequirements")
    private final List<InstallationRequirements> installationRequirements;
    @JsonProperty(value="isRebootRequiredForInstallation")
    private final Boolean isRebootRequiredForInstallation;
    @JsonProperty(value="kbArticleIds")
    private final List<String> kbArticleIds;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().displayName(this.displayName).name(this.name).description(this.description).updateType(this.updateType).sizeInBytes(this.sizeInBytes).isEligibleForInstallation(this.isEligibleForInstallation).installationRequirements(this.installationRequirements).isRebootRequiredForInstallation(this.isRebootRequiredForInstallation).kbArticleIds(this.kbArticleIds);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateTypes getUpdateType() {
        return this.updateType;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public IsEligibleForInstallation getIsEligibleForInstallation() {
        return this.isEligibleForInstallation;
    }

    public List<InstallationRequirements> getInstallationRequirements() {
        return this.installationRequirements;
    }

    public Boolean getIsRebootRequiredForInstallation() {
        return this.isRebootRequiredForInstallation;
    }

    public List<String> getKbArticleIds() {
        return this.kbArticleIds;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowsUpdate)) {
            return false;
        }
        WindowsUpdate other = (WindowsUpdate)o;
        Long this$sizeInBytes = this.getSizeInBytes();
        Long other$sizeInBytes = other.getSizeInBytes();
        if (this$sizeInBytes == null ? other$sizeInBytes != null : !((Object)this$sizeInBytes).equals(other$sizeInBytes)) {
            return false;
        }
        Boolean this$isRebootRequiredForInstallation = this.getIsRebootRequiredForInstallation();
        Boolean other$isRebootRequiredForInstallation = other.getIsRebootRequiredForInstallation();
        if (this$isRebootRequiredForInstallation == null ? other$isRebootRequiredForInstallation != null : !((Object)this$isRebootRequiredForInstallation).equals(other$isRebootRequiredForInstallation)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        UpdateTypes this$updateType = this.getUpdateType();
        UpdateTypes other$updateType = other.getUpdateType();
        if (this$updateType == null ? other$updateType != null : !((Object)((Object)this$updateType)).equals((Object)other$updateType)) {
            return false;
        }
        IsEligibleForInstallation this$isEligibleForInstallation = this.getIsEligibleForInstallation();
        IsEligibleForInstallation other$isEligibleForInstallation = other.getIsEligibleForInstallation();
        if (this$isEligibleForInstallation == null ? other$isEligibleForInstallation != null : !((Object)((Object)this$isEligibleForInstallation)).equals((Object)other$isEligibleForInstallation)) {
            return false;
        }
        List<InstallationRequirements> this$installationRequirements = this.getInstallationRequirements();
        List<InstallationRequirements> other$installationRequirements = other.getInstallationRequirements();
        if (this$installationRequirements == null ? other$installationRequirements != null : !((Object)this$installationRequirements).equals(other$installationRequirements)) {
            return false;
        }
        List<String> this$kbArticleIds = this.getKbArticleIds();
        List<String> other$kbArticleIds = other.getKbArticleIds();
        if (this$kbArticleIds == null ? other$kbArticleIds != null : !((Object)this$kbArticleIds).equals(other$kbArticleIds)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sizeInBytes = this.getSizeInBytes();
        result = result * 59 + ($sizeInBytes == null ? 43 : ((Object)$sizeInBytes).hashCode());
        Boolean $isRebootRequiredForInstallation = this.getIsRebootRequiredForInstallation();
        result = result * 59 + ($isRebootRequiredForInstallation == null ? 43 : ((Object)$isRebootRequiredForInstallation).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        UpdateTypes $updateType = this.getUpdateType();
        result = result * 59 + ($updateType == null ? 43 : ((Object)((Object)$updateType)).hashCode());
        IsEligibleForInstallation $isEligibleForInstallation = this.getIsEligibleForInstallation();
        result = result * 59 + ($isEligibleForInstallation == null ? 43 : ((Object)((Object)$isEligibleForInstallation)).hashCode());
        List<InstallationRequirements> $installationRequirements = this.getInstallationRequirements();
        result = result * 59 + ($installationRequirements == null ? 43 : ((Object)$installationRequirements).hashCode());
        List<String> $kbArticleIds = this.getKbArticleIds();
        result = result * 59 + ($kbArticleIds == null ? 43 : ((Object)$kbArticleIds).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "WindowsUpdate(displayName=" + this.getDisplayName() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", updateType=" + (Object)((Object)this.getUpdateType()) + ", sizeInBytes=" + this.getSizeInBytes() + ", isEligibleForInstallation=" + (Object)((Object)this.getIsEligibleForInstallation()) + ", installationRequirements=" + this.getInstallationRequirements() + ", isRebootRequiredForInstallation=" + this.getIsRebootRequiredForInstallation() + ", kbArticleIds=" + this.getKbArticleIds() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"displayName", "name", "description", "updateType", "sizeInBytes", "isEligibleForInstallation", "installationRequirements", "isRebootRequiredForInstallation", "kbArticleIds"})
    @Deprecated
    public WindowsUpdate(String displayName, String name, String description, UpdateTypes updateType, Long sizeInBytes, IsEligibleForInstallation isEligibleForInstallation, List<InstallationRequirements> installationRequirements, Boolean isRebootRequiredForInstallation, List<String> kbArticleIds) {
        this.displayName = displayName;
        this.name = name;
        this.description = description;
        this.updateType = updateType;
        this.sizeInBytes = sizeInBytes;
        this.isEligibleForInstallation = isEligibleForInstallation;
        this.installationRequirements = installationRequirements;
        this.isRebootRequiredForInstallation = isRebootRequiredForInstallation;
        this.kbArticleIds = kbArticleIds;
    }

    public static enum InstallationRequirements {
        EulaAcceptanceRequired("EULA_ACCEPTANCE_REQUIRED"),
        SoftwareMediaRequired("SOFTWARE_MEDIA_REQUIRED"),
        UserInteractionRequired("USER_INTERACTION_REQUIRED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InstallationRequirements> map;

        private InstallationRequirements(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InstallationRequirements create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InstallationRequirements', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InstallationRequirements.class);
            map = new HashMap<String, InstallationRequirements>();
            for (InstallationRequirements v : InstallationRequirements.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="updateType")
        private UpdateTypes updateType;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="isEligibleForInstallation")
        private IsEligibleForInstallation isEligibleForInstallation;
        @JsonProperty(value="installationRequirements")
        private List<InstallationRequirements> installationRequirements;
        @JsonProperty(value="isRebootRequiredForInstallation")
        private Boolean isRebootRequiredForInstallation;
        @JsonProperty(value="kbArticleIds")
        private List<String> kbArticleIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder updateType(UpdateTypes updateType) {
            this.updateType = updateType;
            this.__explicitlySet__.add("updateType");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder isEligibleForInstallation(IsEligibleForInstallation isEligibleForInstallation) {
            this.isEligibleForInstallation = isEligibleForInstallation;
            this.__explicitlySet__.add("isEligibleForInstallation");
            return this;
        }

        public Builder installationRequirements(List<InstallationRequirements> installationRequirements) {
            this.installationRequirements = installationRequirements;
            this.__explicitlySet__.add("installationRequirements");
            return this;
        }

        public Builder isRebootRequiredForInstallation(Boolean isRebootRequiredForInstallation) {
            this.isRebootRequiredForInstallation = isRebootRequiredForInstallation;
            this.__explicitlySet__.add("isRebootRequiredForInstallation");
            return this;
        }

        public Builder kbArticleIds(List<String> kbArticleIds) {
            this.kbArticleIds = kbArticleIds;
            this.__explicitlySet__.add("kbArticleIds");
            return this;
        }

        public WindowsUpdate build() {
            WindowsUpdate __instance__ = new WindowsUpdate(this.displayName, this.name, this.description, this.updateType, this.sizeInBytes, this.isEligibleForInstallation, this.installationRequirements, this.isRebootRequiredForInstallation, this.kbArticleIds);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(WindowsUpdate o) {
            Builder copiedBuilder = this.displayName(o.getDisplayName()).name(o.getName()).description(o.getDescription()).updateType(o.getUpdateType()).sizeInBytes(o.getSizeInBytes()).isEligibleForInstallation(o.getIsEligibleForInstallation()).installationRequirements(o.getInstallationRequirements()).isRebootRequiredForInstallation(o.getIsRebootRequiredForInstallation()).kbArticleIds(o.getKbArticleIds());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "WindowsUpdate.Builder(displayName=" + this.displayName + ", name=" + this.name + ", description=" + this.description + ", updateType=" + (Object)((Object)this.updateType) + ", sizeInBytes=" + this.sizeInBytes + ", isEligibleForInstallation=" + (Object)((Object)this.isEligibleForInstallation) + ", installationRequirements=" + this.installationRequirements + ", isRebootRequiredForInstallation=" + this.isRebootRequiredForInstallation + ", kbArticleIds=" + this.kbArticleIds + ")";
        }
    }
}

