/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.ResourceManagerAsync;
import com.oracle.bmc.resourcemanager.internal.http.CancelJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.ChangeConfigurationSourceProviderCompartmentConverter;
import com.oracle.bmc.resourcemanager.internal.http.ChangeStackCompartmentConverter;
import com.oracle.bmc.resourcemanager.internal.http.ChangeTemplateCompartmentConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateConfigurationSourceProviderConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateTemplateConverter;
import com.oracle.bmc.resourcemanager.internal.http.DeleteConfigurationSourceProviderConverter;
import com.oracle.bmc.resourcemanager.internal.http.DeleteStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.DeleteTemplateConverter;
import com.oracle.bmc.resourcemanager.internal.http.DetectStackDriftConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetConfigurationSourceProviderConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobLogsContentConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobLogsConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobTfStateConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackTfStateConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetTemplateConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetTemplateLogoConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetTemplateTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListConfigurationSourceProvidersConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListJobsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListResourceDiscoveryServicesConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListStackResourceDriftDetailsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListStacksConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListTemplateCategoriesConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListTemplatesConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListTerraformVersionsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateConfigurationSourceProviderConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateTemplateConverter;
import com.oracle.bmc.resourcemanager.requests.CancelJobRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeConfigurationSourceProviderCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeStackCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeTemplateCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.CreateConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.CreateJobRequest;
import com.oracle.bmc.resourcemanager.requests.CreateStackRequest;
import com.oracle.bmc.resourcemanager.requests.CreateTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteStackRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.DetectStackDriftRequest;
import com.oracle.bmc.resourcemanager.requests.GetConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsContentRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfStateRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackTfStateRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateLogoRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcemanager.requests.ListConfigurationSourceProvidersRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobsRequest;
import com.oracle.bmc.resourcemanager.requests.ListResourceDiscoveryServicesRequest;
import com.oracle.bmc.resourcemanager.requests.ListStackResourceDriftDetailsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStacksRequest;
import com.oracle.bmc.resourcemanager.requests.ListTemplateCategoriesRequest;
import com.oracle.bmc.resourcemanager.requests.ListTemplatesRequest;
import com.oracle.bmc.resourcemanager.requests.ListTerraformVersionsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateJobRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateStackRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateTemplateRequest;
import com.oracle.bmc.resourcemanager.responses.CancelJobResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeConfigurationSourceProviderCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeStackCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeTemplateCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.CreateConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.CreateJobResponse;
import com.oracle.bmc.resourcemanager.responses.CreateStackResponse;
import com.oracle.bmc.resourcemanager.responses.CreateTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteStackResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.DetectStackDriftResponse;
import com.oracle.bmc.resourcemanager.responses.GetConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsContentResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfStateResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackTfStateResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateLogoResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetWorkRequestResponse;
import com.oracle.bmc.resourcemanager.responses.ListConfigurationSourceProvidersResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobsResponse;
import com.oracle.bmc.resourcemanager.responses.ListResourceDiscoveryServicesResponse;
import com.oracle.bmc.resourcemanager.responses.ListStackResourceDriftDetailsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStacksResponse;
import com.oracle.bmc.resourcemanager.responses.ListTemplateCategoriesResponse;
import com.oracle.bmc.resourcemanager.responses.ListTemplatesResponse;
import com.oracle.bmc.resourcemanager.responses.ListTerraformVersionsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestsResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateJobResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateStackResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateTemplateResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerAsyncClient
implements ResourceManagerAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RESOURCEMANAGER").serviceEndpointPrefix("resourcemanager").serviceEndpointTemplate("https://resourcemanager.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ResourceManagerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ResourceManagerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ResourceManagerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ResourceManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ResourceManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ResourceManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ResourceManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ResourceManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CancelJobResponse> cancelJob(CancelJobRequest request, AsyncHandler<CancelJobRequest, CancelJobResponse> handler) {
        LOG.trace("Called async cancelJob");
        CancelJobRequest interceptedRequest = CancelJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelJobResponse> transformer = CancelJobConverter.fromResponse();
        AsyncHandler<CancelJobRequest, CancelJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelJobRequest, CancelJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeConfigurationSourceProviderCompartmentResponse> changeConfigurationSourceProviderCompartment(ChangeConfigurationSourceProviderCompartmentRequest request, AsyncHandler<ChangeConfigurationSourceProviderCompartmentRequest, ChangeConfigurationSourceProviderCompartmentResponse> handler) {
        LOG.trace("Called async changeConfigurationSourceProviderCompartment");
        ChangeConfigurationSourceProviderCompartmentRequest interceptedRequest = ChangeConfigurationSourceProviderCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeConfigurationSourceProviderCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeConfigurationSourceProviderCompartmentResponse> transformer = ChangeConfigurationSourceProviderCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeConfigurationSourceProviderCompartmentRequest, ChangeConfigurationSourceProviderCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeConfigurationSourceProviderCompartmentRequest, ChangeConfigurationSourceProviderCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeStackCompartmentResponse> changeStackCompartment(ChangeStackCompartmentRequest request, AsyncHandler<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse> handler) {
        LOG.trace("Called async changeStackCompartment");
        ChangeStackCompartmentRequest interceptedRequest = ChangeStackCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStackCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeStackCompartmentResponse> transformer = ChangeStackCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeTemplateCompartmentResponse> changeTemplateCompartment(ChangeTemplateCompartmentRequest request, AsyncHandler<ChangeTemplateCompartmentRequest, ChangeTemplateCompartmentResponse> handler) {
        LOG.trace("Called async changeTemplateCompartment");
        ChangeTemplateCompartmentRequest interceptedRequest = ChangeTemplateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeTemplateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeTemplateCompartmentResponse> transformer = ChangeTemplateCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeTemplateCompartmentRequest, ChangeTemplateCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeTemplateCompartmentRequest, ChangeTemplateCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateConfigurationSourceProviderResponse> createConfigurationSourceProvider(CreateConfigurationSourceProviderRequest request, AsyncHandler<CreateConfigurationSourceProviderRequest, CreateConfigurationSourceProviderResponse> handler) {
        LOG.trace("Called async createConfigurationSourceProvider");
        CreateConfigurationSourceProviderRequest interceptedRequest = CreateConfigurationSourceProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConfigurationSourceProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateConfigurationSourceProviderResponse> transformer = CreateConfigurationSourceProviderConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateConfigurationSourceProviderRequest, CreateConfigurationSourceProviderResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateConfigurationSourceProviderRequest, CreateConfigurationSourceProviderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateJobResponse> createJob(CreateJobRequest request, AsyncHandler<CreateJobRequest, CreateJobResponse> handler) {
        LOG.trace("Called async createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateJobRequest, CreateJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateJobRequest, CreateJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateStackResponse> createStack(CreateStackRequest request, AsyncHandler<CreateStackRequest, CreateStackResponse> handler) {
        LOG.trace("Called async createStack");
        CreateStackRequest interceptedRequest = CreateStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateStackResponse> transformer = CreateStackConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateStackRequest, CreateStackResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateStackRequest, CreateStackResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTemplateResponse> createTemplate(CreateTemplateRequest request, AsyncHandler<CreateTemplateRequest, CreateTemplateResponse> handler) {
        LOG.trace("Called async createTemplate");
        CreateTemplateRequest interceptedRequest = CreateTemplateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTemplateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTemplateResponse> transformer = CreateTemplateConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTemplateRequest, CreateTemplateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTemplateRequest, CreateTemplateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteConfigurationSourceProviderResponse> deleteConfigurationSourceProvider(DeleteConfigurationSourceProviderRequest request, AsyncHandler<DeleteConfigurationSourceProviderRequest, DeleteConfigurationSourceProviderResponse> handler) {
        LOG.trace("Called async deleteConfigurationSourceProvider");
        DeleteConfigurationSourceProviderRequest interceptedRequest = DeleteConfigurationSourceProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConfigurationSourceProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConfigurationSourceProviderResponse> transformer = DeleteConfigurationSourceProviderConverter.fromResponse();
        AsyncHandler<DeleteConfigurationSourceProviderRequest, DeleteConfigurationSourceProviderResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteConfigurationSourceProviderRequest, DeleteConfigurationSourceProviderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteStackResponse> deleteStack(DeleteStackRequest request, AsyncHandler<DeleteStackRequest, DeleteStackResponse> handler) {
        LOG.trace("Called async deleteStack");
        DeleteStackRequest interceptedRequest = DeleteStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteStackResponse> transformer = DeleteStackConverter.fromResponse();
        AsyncHandler<DeleteStackRequest, DeleteStackResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteStackRequest, DeleteStackResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTemplateResponse> deleteTemplate(DeleteTemplateRequest request, AsyncHandler<DeleteTemplateRequest, DeleteTemplateResponse> handler) {
        LOG.trace("Called async deleteTemplate");
        DeleteTemplateRequest interceptedRequest = DeleteTemplateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTemplateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTemplateResponse> transformer = DeleteTemplateConverter.fromResponse();
        AsyncHandler<DeleteTemplateRequest, DeleteTemplateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTemplateRequest, DeleteTemplateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectStackDriftResponse> detectStackDrift(DetectStackDriftRequest request, AsyncHandler<DetectStackDriftRequest, DetectStackDriftResponse> handler) {
        LOG.trace("Called async detectStackDrift");
        DetectStackDriftRequest interceptedRequest = DetectStackDriftConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectStackDriftConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetectStackDriftResponse> transformer = DetectStackDriftConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DetectStackDriftRequest, DetectStackDriftResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectStackDriftRequest, DetectStackDriftResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConfigurationSourceProviderResponse> getConfigurationSourceProvider(GetConfigurationSourceProviderRequest request, AsyncHandler<GetConfigurationSourceProviderRequest, GetConfigurationSourceProviderResponse> handler) {
        LOG.trace("Called async getConfigurationSourceProvider");
        GetConfigurationSourceProviderRequest interceptedRequest = GetConfigurationSourceProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConfigurationSourceProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConfigurationSourceProviderResponse> transformer = GetConfigurationSourceProviderConverter.fromResponse();
        AsyncHandler<GetConfigurationSourceProviderRequest, GetConfigurationSourceProviderResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConfigurationSourceProviderRequest, GetConfigurationSourceProviderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobResponse> getJob(GetJobRequest request, AsyncHandler<GetJobRequest, GetJobResponse> handler) {
        LOG.trace("Called async getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        AsyncHandler<GetJobRequest, GetJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobRequest, GetJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobLogsResponse> getJobLogs(GetJobLogsRequest request, AsyncHandler<GetJobLogsRequest, GetJobLogsResponse> handler) {
        LOG.trace("Called async getJobLogs");
        GetJobLogsRequest interceptedRequest = GetJobLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobLogsResponse> transformer = GetJobLogsConverter.fromResponse();
        AsyncHandler<GetJobLogsRequest, GetJobLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobLogsRequest, GetJobLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobLogsContentResponse> getJobLogsContent(GetJobLogsContentRequest request, AsyncHandler<GetJobLogsContentRequest, GetJobLogsContentResponse> handler) {
        LOG.trace("Called async getJobLogsContent");
        GetJobLogsContentRequest interceptedRequest = GetJobLogsContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobLogsContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobLogsContentResponse> transformer = GetJobLogsContentConverter.fromResponse();
        AsyncHandler<GetJobLogsContentRequest, GetJobLogsContentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobLogsContentRequest, GetJobLogsContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobTfConfigResponse> getJobTfConfig(GetJobTfConfigRequest request, AsyncHandler<GetJobTfConfigRequest, GetJobTfConfigResponse> handler) {
        LOG.trace("Called async getJobTfConfig");
        GetJobTfConfigRequest interceptedRequest = GetJobTfConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobTfConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobTfConfigResponse> transformer = GetJobTfConfigConverter.fromResponse();
        AsyncHandler<GetJobTfConfigRequest, GetJobTfConfigResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobTfConfigRequest, GetJobTfConfigResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobTfStateResponse> getJobTfState(GetJobTfStateRequest request, AsyncHandler<GetJobTfStateRequest, GetJobTfStateResponse> handler) {
        LOG.trace("Called async getJobTfState");
        GetJobTfStateRequest interceptedRequest = GetJobTfStateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobTfStateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobTfStateResponse> transformer = GetJobTfStateConverter.fromResponse();
        AsyncHandler<GetJobTfStateRequest, GetJobTfStateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobTfStateRequest, GetJobTfStateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStackResponse> getStack(GetStackRequest request, AsyncHandler<GetStackRequest, GetStackResponse> handler) {
        LOG.trace("Called async getStack");
        GetStackRequest interceptedRequest = GetStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStackResponse> transformer = GetStackConverter.fromResponse();
        AsyncHandler<GetStackRequest, GetStackResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStackRequest, GetStackResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStackTfConfigResponse> getStackTfConfig(GetStackTfConfigRequest request, AsyncHandler<GetStackTfConfigRequest, GetStackTfConfigResponse> handler) {
        LOG.trace("Called async getStackTfConfig");
        GetStackTfConfigRequest interceptedRequest = GetStackTfConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStackTfConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStackTfConfigResponse> transformer = GetStackTfConfigConverter.fromResponse();
        AsyncHandler<GetStackTfConfigRequest, GetStackTfConfigResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStackTfConfigRequest, GetStackTfConfigResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStackTfStateResponse> getStackTfState(GetStackTfStateRequest request, AsyncHandler<GetStackTfStateRequest, GetStackTfStateResponse> handler) {
        LOG.trace("Called async getStackTfState");
        GetStackTfStateRequest interceptedRequest = GetStackTfStateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStackTfStateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStackTfStateResponse> transformer = GetStackTfStateConverter.fromResponse();
        AsyncHandler<GetStackTfStateRequest, GetStackTfStateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStackTfStateRequest, GetStackTfStateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTemplateResponse> getTemplate(GetTemplateRequest request, AsyncHandler<GetTemplateRequest, GetTemplateResponse> handler) {
        LOG.trace("Called async getTemplate");
        GetTemplateRequest interceptedRequest = GetTemplateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTemplateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTemplateResponse> transformer = GetTemplateConverter.fromResponse();
        AsyncHandler<GetTemplateRequest, GetTemplateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTemplateRequest, GetTemplateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTemplateLogoResponse> getTemplateLogo(GetTemplateLogoRequest request, AsyncHandler<GetTemplateLogoRequest, GetTemplateLogoResponse> handler) {
        LOG.trace("Called async getTemplateLogo");
        GetTemplateLogoRequest interceptedRequest = GetTemplateLogoConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTemplateLogoConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTemplateLogoResponse> transformer = GetTemplateLogoConverter.fromResponse();
        AsyncHandler<GetTemplateLogoRequest, GetTemplateLogoResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTemplateLogoRequest, GetTemplateLogoResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTemplateTfConfigResponse> getTemplateTfConfig(GetTemplateTfConfigRequest request, AsyncHandler<GetTemplateTfConfigRequest, GetTemplateTfConfigResponse> handler) {
        LOG.trace("Called async getTemplateTfConfig");
        GetTemplateTfConfigRequest interceptedRequest = GetTemplateTfConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTemplateTfConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTemplateTfConfigResponse> transformer = GetTemplateTfConfigConverter.fromResponse();
        AsyncHandler<GetTemplateTfConfigRequest, GetTemplateTfConfigResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTemplateTfConfigRequest, GetTemplateTfConfigResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConfigurationSourceProvidersResponse> listConfigurationSourceProviders(ListConfigurationSourceProvidersRequest request, AsyncHandler<ListConfigurationSourceProvidersRequest, ListConfigurationSourceProvidersResponse> handler) {
        LOG.trace("Called async listConfigurationSourceProviders");
        ListConfigurationSourceProvidersRequest interceptedRequest = ListConfigurationSourceProvidersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConfigurationSourceProvidersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConfigurationSourceProvidersResponse> transformer = ListConfigurationSourceProvidersConverter.fromResponse();
        AsyncHandler<ListConfigurationSourceProvidersRequest, ListConfigurationSourceProvidersResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConfigurationSourceProvidersRequest, ListConfigurationSourceProvidersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobsResponse> listJobs(ListJobsRequest request, AsyncHandler<ListJobsRequest, ListJobsResponse> handler) {
        LOG.trace("Called async listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        AsyncHandler<ListJobsRequest, ListJobsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobsRequest, ListJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListResourceDiscoveryServicesResponse> listResourceDiscoveryServices(ListResourceDiscoveryServicesRequest request, AsyncHandler<ListResourceDiscoveryServicesRequest, ListResourceDiscoveryServicesResponse> handler) {
        LOG.trace("Called async listResourceDiscoveryServices");
        ListResourceDiscoveryServicesRequest interceptedRequest = ListResourceDiscoveryServicesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResourceDiscoveryServicesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResourceDiscoveryServicesResponse> transformer = ListResourceDiscoveryServicesConverter.fromResponse();
        AsyncHandler<ListResourceDiscoveryServicesRequest, ListResourceDiscoveryServicesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListResourceDiscoveryServicesRequest, ListResourceDiscoveryServicesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListStackResourceDriftDetailsResponse> listStackResourceDriftDetails(ListStackResourceDriftDetailsRequest request, AsyncHandler<ListStackResourceDriftDetailsRequest, ListStackResourceDriftDetailsResponse> handler) {
        LOG.trace("Called async listStackResourceDriftDetails");
        ListStackResourceDriftDetailsRequest interceptedRequest = ListStackResourceDriftDetailsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStackResourceDriftDetailsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStackResourceDriftDetailsResponse> transformer = ListStackResourceDriftDetailsConverter.fromResponse();
        AsyncHandler<ListStackResourceDriftDetailsRequest, ListStackResourceDriftDetailsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListStackResourceDriftDetailsRequest, ListStackResourceDriftDetailsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListStacksResponse> listStacks(ListStacksRequest request, AsyncHandler<ListStacksRequest, ListStacksResponse> handler) {
        LOG.trace("Called async listStacks");
        ListStacksRequest interceptedRequest = ListStacksConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStacksConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStacksResponse> transformer = ListStacksConverter.fromResponse();
        AsyncHandler<ListStacksRequest, ListStacksResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListStacksRequest, ListStacksResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTemplateCategoriesResponse> listTemplateCategories(ListTemplateCategoriesRequest request, AsyncHandler<ListTemplateCategoriesRequest, ListTemplateCategoriesResponse> handler) {
        LOG.trace("Called async listTemplateCategories");
        ListTemplateCategoriesRequest interceptedRequest = ListTemplateCategoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTemplateCategoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTemplateCategoriesResponse> transformer = ListTemplateCategoriesConverter.fromResponse();
        AsyncHandler<ListTemplateCategoriesRequest, ListTemplateCategoriesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTemplateCategoriesRequest, ListTemplateCategoriesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTemplatesResponse> listTemplates(ListTemplatesRequest request, AsyncHandler<ListTemplatesRequest, ListTemplatesResponse> handler) {
        LOG.trace("Called async listTemplates");
        ListTemplatesRequest interceptedRequest = ListTemplatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTemplatesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTemplatesResponse> transformer = ListTemplatesConverter.fromResponse();
        AsyncHandler<ListTemplatesRequest, ListTemplatesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTemplatesRequest, ListTemplatesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTerraformVersionsResponse> listTerraformVersions(ListTerraformVersionsRequest request, AsyncHandler<ListTerraformVersionsRequest, ListTerraformVersionsResponse> handler) {
        LOG.trace("Called async listTerraformVersions");
        ListTerraformVersionsRequest interceptedRequest = ListTerraformVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTerraformVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTerraformVersionsResponse> transformer = ListTerraformVersionsConverter.fromResponse();
        AsyncHandler<ListTerraformVersionsRequest, ListTerraformVersionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTerraformVersionsRequest, ListTerraformVersionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateConfigurationSourceProviderResponse> updateConfigurationSourceProvider(UpdateConfigurationSourceProviderRequest request, AsyncHandler<UpdateConfigurationSourceProviderRequest, UpdateConfigurationSourceProviderResponse> handler) {
        LOG.trace("Called async updateConfigurationSourceProvider");
        UpdateConfigurationSourceProviderRequest interceptedRequest = UpdateConfigurationSourceProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConfigurationSourceProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConfigurationSourceProviderResponse> transformer = UpdateConfigurationSourceProviderConverter.fromResponse();
        AsyncHandler<UpdateConfigurationSourceProviderRequest, UpdateConfigurationSourceProviderResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateConfigurationSourceProviderRequest, UpdateConfigurationSourceProviderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateJobResponse> updateJob(UpdateJobRequest request, AsyncHandler<UpdateJobRequest, UpdateJobResponse> handler) {
        LOG.trace("Called async updateJob");
        UpdateJobRequest interceptedRequest = UpdateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateJobResponse> transformer = UpdateJobConverter.fromResponse();
        AsyncHandler<UpdateJobRequest, UpdateJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateJobRequest, UpdateJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateStackResponse> updateStack(UpdateStackRequest request, AsyncHandler<UpdateStackRequest, UpdateStackResponse> handler) {
        LOG.trace("Called async updateStack");
        UpdateStackRequest interceptedRequest = UpdateStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateStackResponse> transformer = UpdateStackConverter.fromResponse();
        AsyncHandler<UpdateStackRequest, UpdateStackResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateStackRequest, UpdateStackResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTemplateResponse> updateTemplate(UpdateTemplateRequest request, AsyncHandler<UpdateTemplateRequest, UpdateTemplateResponse> handler) {
        LOG.trace("Called async updateTemplate");
        UpdateTemplateRequest interceptedRequest = UpdateTemplateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTemplateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTemplateResponse> transformer = UpdateTemplateConverter.fromResponse();
        AsyncHandler<UpdateTemplateRequest, UpdateTemplateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTemplateRequest, UpdateTemplateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ResourceManagerAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ResourceManagerAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ResourceManagerAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

