/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetConfigurationSourceProviderRequest
extends BmcRequest<Void> {
    private String configurationSourceProviderId;
    private String opcRequestId;

    @ConstructorProperties(value={"configurationSourceProviderId", "opcRequestId"})
    GetConfigurationSourceProviderRequest(String configurationSourceProviderId, String opcRequestId) {
        this.configurationSourceProviderId = configurationSourceProviderId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getConfigurationSourceProviderId() {
        return this.configurationSourceProviderId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConfigurationSourceProviderRequest, Void> {
        private String configurationSourceProviderId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConfigurationSourceProviderRequest o) {
            this.configurationSourceProviderId(o.getConfigurationSourceProviderId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConfigurationSourceProviderRequest build() {
            GetConfigurationSourceProviderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder configurationSourceProviderId(String configurationSourceProviderId) {
            this.configurationSourceProviderId = configurationSourceProviderId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetConfigurationSourceProviderRequest buildWithoutInvocationCallback() {
            return new GetConfigurationSourceProviderRequest(this.configurationSourceProviderId, this.opcRequestId);
        }

        public String toString() {
            return "GetConfigurationSourceProviderRequest.Builder(configurationSourceProviderId=" + this.configurationSourceProviderId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

