/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListConfigurationSourceProvidersRequest
extends BmcRequest<Void> {
    private String opcRequestId;
    private String compartmentId;
    private String configurationSourceProviderId;
    private String displayName;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String configSourceProviderType;

    @ConstructorProperties(value={"opcRequestId", "compartmentId", "configurationSourceProviderId", "displayName", "sortBy", "sortOrder", "limit", "page", "configSourceProviderType"})
    ListConfigurationSourceProvidersRequest(String opcRequestId, String compartmentId, String configurationSourceProviderId, String displayName, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String configSourceProviderType) {
        this.opcRequestId = opcRequestId;
        this.compartmentId = compartmentId;
        this.configurationSourceProviderId = configurationSourceProviderId;
        this.displayName = displayName;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.configSourceProviderType = configSourceProviderType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getConfigurationSourceProviderId() {
        return this.configurationSourceProviderId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getConfigSourceProviderType() {
        return this.configSourceProviderType;
    }

    public static class Builder
    implements BmcRequest.Builder<ListConfigurationSourceProvidersRequest, Void> {
        private String opcRequestId;
        private String compartmentId;
        private String configurationSourceProviderId;
        private String displayName;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String configSourceProviderType;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListConfigurationSourceProvidersRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentId(o.getCompartmentId());
            this.configurationSourceProviderId(o.getConfigurationSourceProviderId());
            this.displayName(o.getDisplayName());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.configSourceProviderType(o.getConfigSourceProviderType());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListConfigurationSourceProvidersRequest build() {
            ListConfigurationSourceProvidersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder configurationSourceProviderId(String configurationSourceProviderId) {
            this.configurationSourceProviderId = configurationSourceProviderId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder configSourceProviderType(String configSourceProviderType) {
            this.configSourceProviderType = configSourceProviderType;
            return this;
        }

        public ListConfigurationSourceProvidersRequest buildWithoutInvocationCallback() {
            return new ListConfigurationSourceProvidersRequest(this.opcRequestId, this.compartmentId, this.configurationSourceProviderId, this.displayName, this.sortBy, this.sortOrder, this.limit, this.page, this.configSourceProviderType);
        }

        public String toString() {
            return "ListConfigurationSourceProvidersRequest.Builder(opcRequestId=" + this.opcRequestId + ", compartmentId=" + this.compartmentId + ", configurationSourceProviderId=" + this.configurationSourceProviderId + ", displayName=" + this.displayName + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", configSourceProviderType=" + this.configSourceProviderType + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

