/**
 * Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.rover.requests.*;
import com.oracle.bmc.rover.responses.*;

/**
 * A description of the RoverCloudService API.
 */
@javax.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20201210")
public interface RoverNode extends AutoCloseable {

    /**
     * Sets the endpoint to call (ex, https://www.example.com).
     * @param endpoint The endpoint of the service.
     */
    void setEndpoint(String endpoint);

    /**
     * Gets the set endpoint for REST call (ex, https://www.example.com)
     */
    String getEndpoint();

    /**
     * Sets the region to call (ex, Region.US_PHOENIX_1).
     * <p>
     * Note, this will call {@link #setEndpoint(String) setEndpoint} after resolving the endpoint.  If the service is not available in this Region, however, an IllegalArgumentException will be raised.
     * @param region The region of the service.
     */
    void setRegion(com.oracle.bmc.Region region);

    /**
     * Sets the region to call (ex, 'us-phoenix-1').
     * <p>
     * Note, this will first try to map the region ID to a known Region and call
     * {@link #setRegion(Region) setRegion}.
     * <p>
     * If no known Region could be determined, it will create an endpoint based on the
     * default endpoint format ({@link com.oracle.bmc.Region#formatDefaultRegionEndpoint(Service, String)}
     * and then call {@link #setEndpoint(String) setEndpoint}.
     * @param regionId The public region ID.
     */
    void setRegion(String regionId);

    /**
     * Moves a rover node into a different compartment.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/ChangeRoverNodeCompartmentExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ChangeRoverNodeCompartment API.
     */
    ChangeRoverNodeCompartmentResponse changeRoverNodeCompartment(
            ChangeRoverNodeCompartmentRequest request);

    /**
     * Creates a new RoverNode.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/CreateRoverNodeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use CreateRoverNode API.
     */
    CreateRoverNodeResponse createRoverNode(CreateRoverNodeRequest request);

    /**
     * Deletes a RoverNode resource by identifier
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/DeleteRoverNodeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use DeleteRoverNode API.
     */
    DeleteRoverNodeResponse deleteRoverNode(DeleteRoverNodeRequest request);

    /**
     * Gets a RoverNode by identifier.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/GetRoverNodeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetRoverNode API.
     */
    GetRoverNodeResponse getRoverNode(GetRoverNodeRequest request);

    /**
     * Get the certificate for a rover node
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/GetRoverNodeCertificateExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetRoverNodeCertificate API.
     */
    GetRoverNodeCertificateResponse getRoverNodeCertificate(GetRoverNodeCertificateRequest request);

    /**
     * Get the data encryption key for a rover node.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/GetRoverNodeEncryptionKeyExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetRoverNodeEncryptionKey API.
     */
    GetRoverNodeEncryptionKeyResponse getRoverNodeEncryptionKey(
            GetRoverNodeEncryptionKeyRequest request);

    /**
     * Get the resource principal token for a rover node
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/GetRoverNodeGetRptExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetRoverNodeGetRpt API.
     */
    GetRoverNodeGetRptResponse getRoverNodeGetRpt(GetRoverNodeGetRptRequest request);

    /**
     * Returns a list of RoverNodes.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/ListRoverNodesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListRoverNodes API.
     */
    ListRoverNodesResponse listRoverNodes(ListRoverNodesRequest request);

    /**
     * Get the resource principal public key for a rover node
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/RoverNodeActionSetKeyExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use RoverNodeActionSetKey API.
     */
    RoverNodeActionSetKeyResponse roverNodeActionSetKey(RoverNodeActionSetKeyRequest request);

    /**
     * Updates the RoverNode
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/rover/UpdateRoverNodeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateRoverNode API.
     */
    UpdateRoverNodeResponse updateRoverNode(UpdateRoverNodeRequest request);

    /**
     * Gets the pre-configured waiters available for resources for this service.
     *
     * @return The service waiters.
     */
    RoverNodeWaiters getWaiters();

    /**
     * Gets the pre-configured paginators available for list operations in this service which may return multiple
     * pages of data. These paginators provide an {@link java.lang.Iterable} interface so that service responses, or
     * resources/records, can be iterated through without having to manually deal with pagination and page tokens.
     *
     * @return The service paginators.
     */
    RoverNodePaginators getPaginators();
}
