/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.sch.ServiceConnectorAsync;
import com.oracle.bmc.sch.internal.http.ActivateServiceConnectorConverter;
import com.oracle.bmc.sch.internal.http.ChangeServiceConnectorCompartmentConverter;
import com.oracle.bmc.sch.internal.http.CreateServiceConnectorConverter;
import com.oracle.bmc.sch.internal.http.DeactivateServiceConnectorConverter;
import com.oracle.bmc.sch.internal.http.DeleteServiceConnectorConverter;
import com.oracle.bmc.sch.internal.http.GetServiceConnectorConverter;
import com.oracle.bmc.sch.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.sch.internal.http.ListServiceConnectorsConverter;
import com.oracle.bmc.sch.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.sch.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.sch.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.sch.internal.http.UpdateServiceConnectorConverter;
import com.oracle.bmc.sch.requests.ActivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.ChangeServiceConnectorCompartmentRequest;
import com.oracle.bmc.sch.requests.CreateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeactivateServiceConnectorRequest;
import com.oracle.bmc.sch.requests.DeleteServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetServiceConnectorRequest;
import com.oracle.bmc.sch.requests.GetWorkRequestRequest;
import com.oracle.bmc.sch.requests.ListServiceConnectorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.sch.requests.ListWorkRequestsRequest;
import com.oracle.bmc.sch.requests.UpdateServiceConnectorRequest;
import com.oracle.bmc.sch.responses.ActivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.ChangeServiceConnectorCompartmentResponse;
import com.oracle.bmc.sch.responses.CreateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeactivateServiceConnectorResponse;
import com.oracle.bmc.sch.responses.DeleteServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetServiceConnectorResponse;
import com.oracle.bmc.sch.responses.GetWorkRequestResponse;
import com.oracle.bmc.sch.responses.ListServiceConnectorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.sch.responses.ListWorkRequestsResponse;
import com.oracle.bmc.sch.responses.UpdateServiceConnectorResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceConnectorAsyncClient
implements ServiceConnectorAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConnectorAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SERVICECONNECTOR").serviceEndpointPrefix("").serviceEndpointTemplate("https://service-connector-hub.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ServiceConnectorAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ServiceConnectorAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ServiceConnectorAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ServiceConnectorAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ServiceConnectorAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ServiceConnectorAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ServiceConnectorAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ServiceConnectorAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ActivateServiceConnectorResponse> activateServiceConnector(ActivateServiceConnectorRequest request, AsyncHandler<ActivateServiceConnectorRequest, ActivateServiceConnectorResponse> handler) {
        LOG.trace("Called async activateServiceConnector");
        ActivateServiceConnectorRequest interceptedRequest = ActivateServiceConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateServiceConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ActivateServiceConnectorResponse> transformer = ActivateServiceConnectorConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ActivateServiceConnectorRequest, ActivateServiceConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ActivateServiceConnectorRequest, ActivateServiceConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeServiceConnectorCompartmentResponse> changeServiceConnectorCompartment(ChangeServiceConnectorCompartmentRequest request, AsyncHandler<ChangeServiceConnectorCompartmentRequest, ChangeServiceConnectorCompartmentResponse> handler) {
        LOG.trace("Called async changeServiceConnectorCompartment");
        ChangeServiceConnectorCompartmentRequest interceptedRequest = ChangeServiceConnectorCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeServiceConnectorCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeServiceConnectorCompartmentResponse> transformer = ChangeServiceConnectorCompartmentConverter.fromResponse();
        AsyncHandler<ChangeServiceConnectorCompartmentRequest, ChangeServiceConnectorCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeServiceConnectorCompartmentRequest, ChangeServiceConnectorCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateServiceConnectorResponse> createServiceConnector(CreateServiceConnectorRequest request, AsyncHandler<CreateServiceConnectorRequest, CreateServiceConnectorResponse> handler) {
        LOG.trace("Called async createServiceConnector");
        CreateServiceConnectorRequest interceptedRequest = CreateServiceConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateServiceConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateServiceConnectorResponse> transformer = CreateServiceConnectorConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateServiceConnectorRequest, CreateServiceConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateServiceConnectorRequest, CreateServiceConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeactivateServiceConnectorResponse> deactivateServiceConnector(DeactivateServiceConnectorRequest request, AsyncHandler<DeactivateServiceConnectorRequest, DeactivateServiceConnectorResponse> handler) {
        LOG.trace("Called async deactivateServiceConnector");
        DeactivateServiceConnectorRequest interceptedRequest = DeactivateServiceConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateServiceConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeactivateServiceConnectorResponse> transformer = DeactivateServiceConnectorConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeactivateServiceConnectorRequest, DeactivateServiceConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeactivateServiceConnectorRequest, DeactivateServiceConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteServiceConnectorResponse> deleteServiceConnector(DeleteServiceConnectorRequest request, AsyncHandler<DeleteServiceConnectorRequest, DeleteServiceConnectorResponse> handler) {
        LOG.trace("Called async deleteServiceConnector");
        DeleteServiceConnectorRequest interceptedRequest = DeleteServiceConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteServiceConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteServiceConnectorResponse> transformer = DeleteServiceConnectorConverter.fromResponse();
        AsyncHandler<DeleteServiceConnectorRequest, DeleteServiceConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteServiceConnectorRequest, DeleteServiceConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetServiceConnectorResponse> getServiceConnector(GetServiceConnectorRequest request, AsyncHandler<GetServiceConnectorRequest, GetServiceConnectorResponse> handler) {
        LOG.trace("Called async getServiceConnector");
        GetServiceConnectorRequest interceptedRequest = GetServiceConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetServiceConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetServiceConnectorResponse> transformer = GetServiceConnectorConverter.fromResponse();
        AsyncHandler<GetServiceConnectorRequest, GetServiceConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetServiceConnectorRequest, GetServiceConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListServiceConnectorsResponse> listServiceConnectors(ListServiceConnectorsRequest request, AsyncHandler<ListServiceConnectorsRequest, ListServiceConnectorsResponse> handler) {
        LOG.trace("Called async listServiceConnectors");
        ListServiceConnectorsRequest interceptedRequest = ListServiceConnectorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListServiceConnectorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListServiceConnectorsResponse> transformer = ListServiceConnectorsConverter.fromResponse();
        AsyncHandler<ListServiceConnectorsRequest, ListServiceConnectorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListServiceConnectorsRequest, ListServiceConnectorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateServiceConnectorResponse> updateServiceConnector(UpdateServiceConnectorRequest request, AsyncHandler<UpdateServiceConnectorRequest, UpdateServiceConnectorResponse> handler) {
        LOG.trace("Called async updateServiceConnector");
        UpdateServiceConnectorRequest interceptedRequest = UpdateServiceConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateServiceConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateServiceConnectorResponse> transformer = UpdateServiceConnectorConverter.fromResponse();
        AsyncHandler<UpdateServiceConnectorRequest, UpdateServiceConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateServiceConnectorRequest, UpdateServiceConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ServiceConnectorAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ServiceConnectorAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ServiceConnectorAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

