/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteServiceConnectorRequest
extends BmcRequest<Void> {
    private String serviceConnectorId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"serviceConnectorId", "ifMatch", "opcRequestId"})
    DeleteServiceConnectorRequest(String serviceConnectorId, String ifMatch, String opcRequestId) {
        this.serviceConnectorId = serviceConnectorId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getServiceConnectorId() {
        return this.serviceConnectorId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteServiceConnectorRequest, Void> {
        private String serviceConnectorId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteServiceConnectorRequest o) {
            this.serviceConnectorId(o.getServiceConnectorId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteServiceConnectorRequest build() {
            DeleteServiceConnectorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder serviceConnectorId(String serviceConnectorId) {
            this.serviceConnectorId = serviceConnectorId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteServiceConnectorRequest buildWithoutInvocationCallback() {
            return new DeleteServiceConnectorRequest(this.serviceConnectorId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteServiceConnectorRequest.Builder(serviceConnectorId=" + this.serviceConnectorId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

