/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.adm.model;

/**
 * Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its
 * name does match any of the items in {@code exclusions}, or all of the associated Vulnerabilies
 * have a CVSS v2 score below {@code maxPermissibleCvssV2Score} and a CVSS v3 score below {@code
 * maxPermissibleCvssV3Score}. type: object <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220421")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = VulnerabilityAuditConfiguration.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class VulnerabilityAuditConfiguration
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "maxPermissibleCvssV2Score",
        "maxPermissibleCvssV3Score",
        "maxPermissibleSeverity",
        "exclusions"
    })
    public VulnerabilityAuditConfiguration(
            Float maxPermissibleCvssV2Score,
            Float maxPermissibleCvssV3Score,
            ConfigSeverity maxPermissibleSeverity,
            java.util.List<String> exclusions) {
        super();
        this.maxPermissibleCvssV2Score = maxPermissibleCvssV2Score;
        this.maxPermissibleCvssV3Score = maxPermissibleCvssV3Score;
        this.maxPermissibleSeverity = maxPermissibleSeverity;
        this.exclusions = exclusions;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * A vulnerable application dependency is ignored if the score of its associated
         * Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("maxPermissibleCvssV2Score")
        private Float maxPermissibleCvssV2Score;

        /**
         * A vulnerable application dependency is ignored if the score of its associated
         * Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
         *
         * @param maxPermissibleCvssV2Score the value to set
         * @return this builder
         */
        public Builder maxPermissibleCvssV2Score(Float maxPermissibleCvssV2Score) {
            this.maxPermissibleCvssV2Score = maxPermissibleCvssV2Score;
            this.__explicitlySet__.add("maxPermissibleCvssV2Score");
            return this;
        }
        /**
         * A vulnerable application dependency is ignored if the score of its associated
         * Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("maxPermissibleCvssV3Score")
        private Float maxPermissibleCvssV3Score;

        /**
         * A vulnerable application dependency is ignored if the score of its associated
         * Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
         *
         * @param maxPermissibleCvssV3Score the value to set
         * @return this builder
         */
        public Builder maxPermissibleCvssV3Score(Float maxPermissibleCvssV3Score) {
            this.maxPermissibleCvssV3Score = maxPermissibleCvssV3Score;
            this.__explicitlySet__.add("maxPermissibleCvssV3Score");
            return this;
        }
        /**
         * A vulnerable application dependency is ignored if the score of its associated
         * Vulnerability is below maxPermissibleSeverity.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("maxPermissibleSeverity")
        private ConfigSeverity maxPermissibleSeverity;

        /**
         * A vulnerable application dependency is ignored if the score of its associated
         * Vulnerability is below maxPermissibleSeverity.
         *
         * @param maxPermissibleSeverity the value to set
         * @return this builder
         */
        public Builder maxPermissibleSeverity(ConfigSeverity maxPermissibleSeverity) {
            this.maxPermissibleSeverity = maxPermissibleSeverity;
            this.__explicitlySet__.add("maxPermissibleSeverity");
            return this;
        }
        /**
         * A vulnerable application dependency is ignored if its name matches any of the items in
         * {@code exclusions}. An asterisk (*) in the dependency pattern acts as a wildcard and
         * matches zero or more characters.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("exclusions")
        private java.util.List<String> exclusions;

        /**
         * A vulnerable application dependency is ignored if its name matches any of the items in
         * {@code exclusions}. An asterisk (*) in the dependency pattern acts as a wildcard and
         * matches zero or more characters.
         *
         * @param exclusions the value to set
         * @return this builder
         */
        public Builder exclusions(java.util.List<String> exclusions) {
            this.exclusions = exclusions;
            this.__explicitlySet__.add("exclusions");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public VulnerabilityAuditConfiguration build() {
            VulnerabilityAuditConfiguration model =
                    new VulnerabilityAuditConfiguration(
                            this.maxPermissibleCvssV2Score,
                            this.maxPermissibleCvssV3Score,
                            this.maxPermissibleSeverity,
                            this.exclusions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(VulnerabilityAuditConfiguration model) {
            if (model.wasPropertyExplicitlySet("maxPermissibleCvssV2Score")) {
                this.maxPermissibleCvssV2Score(model.getMaxPermissibleCvssV2Score());
            }
            if (model.wasPropertyExplicitlySet("maxPermissibleCvssV3Score")) {
                this.maxPermissibleCvssV3Score(model.getMaxPermissibleCvssV3Score());
            }
            if (model.wasPropertyExplicitlySet("maxPermissibleSeverity")) {
                this.maxPermissibleSeverity(model.getMaxPermissibleSeverity());
            }
            if (model.wasPropertyExplicitlySet("exclusions")) {
                this.exclusions(model.getExclusions());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * A vulnerable application dependency is ignored if the score of its associated Vulnerability
     * is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("maxPermissibleCvssV2Score")
    private final Float maxPermissibleCvssV2Score;

    /**
     * A vulnerable application dependency is ignored if the score of its associated Vulnerability
     * is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
     *
     * @return the value
     */
    public Float getMaxPermissibleCvssV2Score() {
        return maxPermissibleCvssV2Score;
    }

    /**
     * A vulnerable application dependency is ignored if the score of its associated Vulnerability
     * is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("maxPermissibleCvssV3Score")
    private final Float maxPermissibleCvssV3Score;

    /**
     * A vulnerable application dependency is ignored if the score of its associated Vulnerability
     * is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
     *
     * @return the value
     */
    public Float getMaxPermissibleCvssV3Score() {
        return maxPermissibleCvssV3Score;
    }

    /**
     * A vulnerable application dependency is ignored if the score of its associated Vulnerability
     * is below maxPermissibleSeverity.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("maxPermissibleSeverity")
    private final ConfigSeverity maxPermissibleSeverity;

    /**
     * A vulnerable application dependency is ignored if the score of its associated Vulnerability
     * is below maxPermissibleSeverity.
     *
     * @return the value
     */
    public ConfigSeverity getMaxPermissibleSeverity() {
        return maxPermissibleSeverity;
    }

    /**
     * A vulnerable application dependency is ignored if its name matches any of the items in {@code
     * exclusions}. An asterisk (*) in the dependency pattern acts as a wildcard and matches zero or
     * more characters.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("exclusions")
    private final java.util.List<String> exclusions;

    /**
     * A vulnerable application dependency is ignored if its name matches any of the items in {@code
     * exclusions}. An asterisk (*) in the dependency pattern acts as a wildcard and matches zero or
     * more characters.
     *
     * @return the value
     */
    public java.util.List<String> getExclusions() {
        return exclusions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("VulnerabilityAuditConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("maxPermissibleCvssV2Score=")
                .append(String.valueOf(this.maxPermissibleCvssV2Score));
        sb.append(", maxPermissibleCvssV3Score=")
                .append(String.valueOf(this.maxPermissibleCvssV3Score));
        sb.append(", maxPermissibleSeverity=").append(String.valueOf(this.maxPermissibleSeverity));
        sb.append(", exclusions=").append(String.valueOf(this.exclusions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilityAuditConfiguration)) {
            return false;
        }

        VulnerabilityAuditConfiguration other = (VulnerabilityAuditConfiguration) o;
        return java.util.Objects.equals(
                        this.maxPermissibleCvssV2Score, other.maxPermissibleCvssV2Score)
                && java.util.Objects.equals(
                        this.maxPermissibleCvssV3Score, other.maxPermissibleCvssV3Score)
                && java.util.Objects.equals(
                        this.maxPermissibleSeverity, other.maxPermissibleSeverity)
                && java.util.Objects.equals(this.exclusions, other.exclusions)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.maxPermissibleCvssV2Score == null
                                ? 43
                                : this.maxPermissibleCvssV2Score.hashCode());
        result =
                (result * PRIME)
                        + (this.maxPermissibleCvssV3Score == null
                                ? 43
                                : this.maxPermissibleCvssV3Score.hashCode());
        result =
                (result * PRIME)
                        + (this.maxPermissibleSeverity == null
                                ? 43
                                : this.maxPermissibleSeverity.hashCode());
        result = (result * PRIME) + (this.exclusions == null ? 43 : this.exclusions.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
