/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.devops.model;

/**
 * Protection level to be added on the branch. READ_ONLY: Makes the branch read-only. All changes to
 * the branch will be rejected. PULL_REQUEST_MERGE_ONLY: Changes to a branch are only accepted via a
 * pull request.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210630")
public enum ProtectionLevel implements com.oracle.bmc.http.internal.BmcEnum {
    ReadOnly("READ_ONLY"),
    PullRequestMergeOnly("PULL_REQUEST_MERGE_ONLY"),

    /**
     * This value is used if a service returns a value for this enum that is not recognized by this
     * version of the SDK.
     */
    UnknownEnumValue(null);

    private static final org.slf4j.Logger LOG =
            org.slf4j.LoggerFactory.getLogger(ProtectionLevel.class);

    private final String value;
    private static java.util.Map<String, ProtectionLevel> map;

    static {
        map = new java.util.HashMap<>();
        for (ProtectionLevel v : ProtectionLevel.values()) {
            if (v != UnknownEnumValue) {
                map.put(v.getValue(), v);
            }
        }
    }

    ProtectionLevel(String value) {
        this.value = value;
    }

    @com.fasterxml.jackson.annotation.JsonValue
    public String getValue() {
        return value;
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    public static ProtectionLevel create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn(
                "Received unknown value '{}' for enum 'ProtectionLevel', returning UnknownEnumValue",
                key);
        return UnknownEnumValue;
    }
}
