/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.fleetappsmanagement.model;

/**
 * Request to initiate target discovery <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20230831")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = RequestTargetDiscoveryDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class RequestTargetDiscoveryDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"isApplicableToAllResources", "resourceIds"})
    public RequestTargetDiscoveryDetails(
            Boolean isApplicableToAllResources, java.util.List<String> resourceIds) {
        super();
        this.isApplicableToAllResources = isApplicableToAllResources;
        this.resourceIds = resourceIds;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * A boolean flag which decides if all resources within the fleet should be part of
         * discovery.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("isApplicableToAllResources")
        private Boolean isApplicableToAllResources;

        /**
         * A boolean flag which decides if all resources within the fleet should be part of
         * discovery.
         *
         * @param isApplicableToAllResources the value to set
         * @return this builder
         */
        public Builder isApplicableToAllResources(Boolean isApplicableToAllResources) {
            this.isApplicableToAllResources = isApplicableToAllResources;
            this.__explicitlySet__.add("isApplicableToAllResources");
            return this;
        }
        /** Resource OCIDS that need to be included for discovery. */
        @com.fasterxml.jackson.annotation.JsonProperty("resourceIds")
        private java.util.List<String> resourceIds;

        /**
         * Resource OCIDS that need to be included for discovery.
         *
         * @param resourceIds the value to set
         * @return this builder
         */
        public Builder resourceIds(java.util.List<String> resourceIds) {
            this.resourceIds = resourceIds;
            this.__explicitlySet__.add("resourceIds");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public RequestTargetDiscoveryDetails build() {
            RequestTargetDiscoveryDetails model =
                    new RequestTargetDiscoveryDetails(
                            this.isApplicableToAllResources, this.resourceIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(RequestTargetDiscoveryDetails model) {
            if (model.wasPropertyExplicitlySet("isApplicableToAllResources")) {
                this.isApplicableToAllResources(model.getIsApplicableToAllResources());
            }
            if (model.wasPropertyExplicitlySet("resourceIds")) {
                this.resourceIds(model.getResourceIds());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * A boolean flag which decides if all resources within the fleet should be part of discovery.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isApplicableToAllResources")
    private final Boolean isApplicableToAllResources;

    /**
     * A boolean flag which decides if all resources within the fleet should be part of discovery.
     *
     * @return the value
     */
    public Boolean getIsApplicableToAllResources() {
        return isApplicableToAllResources;
    }

    /** Resource OCIDS that need to be included for discovery. */
    @com.fasterxml.jackson.annotation.JsonProperty("resourceIds")
    private final java.util.List<String> resourceIds;

    /**
     * Resource OCIDS that need to be included for discovery.
     *
     * @return the value
     */
    public java.util.List<String> getResourceIds() {
        return resourceIds;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("RequestTargetDiscoveryDetails(");
        sb.append("super=").append(super.toString());
        sb.append("isApplicableToAllResources=")
                .append(String.valueOf(this.isApplicableToAllResources));
        sb.append(", resourceIds=").append(String.valueOf(this.resourceIds));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestTargetDiscoveryDetails)) {
            return false;
        }

        RequestTargetDiscoveryDetails other = (RequestTargetDiscoveryDetails) o;
        return java.util.Objects.equals(
                        this.isApplicableToAllResources, other.isApplicableToAllResources)
                && java.util.Objects.equals(this.resourceIds, other.resourceIds)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.isApplicableToAllResources == null
                                ? 43
                                : this.isApplicableToAllResources.hashCode());
        result = (result * PRIME) + (this.resourceIds == null ? 43 : this.resourceIds.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
