/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.identitydomains.model;

/**
 * Device Resource. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: v1")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = MyDevice.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class MyDevice extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "ocid",
        "schemas",
        "meta",
        "idcsCreatedBy",
        "idcsLastModifiedBy",
        "idcsPreventedOperations",
        "tags",
        "deleteInProgress",
        "idcsLastUpgradedInRelease",
        "domainOcid",
        "compartmentOcid",
        "tenancyOcid",
        "externalId",
        "displayName",
        "platform",
        "status",
        "reason",
        "deviceType",
        "appVersion",
        "packageId",
        "lastSyncTime",
        "lastValidatedTime",
        "isCompliant",
        "countryCode",
        "phoneNumber",
        "isAccRecEnabled",
        "deviceUUID",
        "basePublicKey",
        "authenticationMethod",
        "expiresOn",
        "seedDekId",
        "seed",
        "thirdPartyFactor",
        "user",
        "pushNotificationTarget",
        "additionalAttributes",
        "authenticationFactors",
        "nonCompliances"
    })
    public MyDevice(
            String id,
            String ocid,
            java.util.List<String> schemas,
            Meta meta,
            IdcsCreatedBy idcsCreatedBy,
            IdcsLastModifiedBy idcsLastModifiedBy,
            java.util.List<IdcsPreventedOperations> idcsPreventedOperations,
            java.util.List<Tags> tags,
            Boolean deleteInProgress,
            String idcsLastUpgradedInRelease,
            String domainOcid,
            String compartmentOcid,
            String tenancyOcid,
            String externalId,
            String displayName,
            Platform platform,
            Status status,
            String reason,
            String deviceType,
            String appVersion,
            String packageId,
            String lastSyncTime,
            String lastValidatedTime,
            Boolean isCompliant,
            String countryCode,
            String phoneNumber,
            Boolean isAccRecEnabled,
            String deviceUUID,
            String basePublicKey,
            String authenticationMethod,
            Integer expiresOn,
            String seedDekId,
            String seed,
            MyDeviceThirdPartyFactor thirdPartyFactor,
            MyDeviceUser user,
            MyDevicePushNotificationTarget pushNotificationTarget,
            java.util.List<MyDeviceAdditionalAttributes> additionalAttributes,
            java.util.List<MyDeviceAuthenticationFactors> authenticationFactors,
            java.util.List<MyDeviceNonCompliances> nonCompliances) {
        super();
        this.id = id;
        this.ocid = ocid;
        this.schemas = schemas;
        this.meta = meta;
        this.idcsCreatedBy = idcsCreatedBy;
        this.idcsLastModifiedBy = idcsLastModifiedBy;
        this.idcsPreventedOperations = idcsPreventedOperations;
        this.tags = tags;
        this.deleteInProgress = deleteInProgress;
        this.idcsLastUpgradedInRelease = idcsLastUpgradedInRelease;
        this.domainOcid = domainOcid;
        this.compartmentOcid = compartmentOcid;
        this.tenancyOcid = tenancyOcid;
        this.externalId = externalId;
        this.displayName = displayName;
        this.platform = platform;
        this.status = status;
        this.reason = reason;
        this.deviceType = deviceType;
        this.appVersion = appVersion;
        this.packageId = packageId;
        this.lastSyncTime = lastSyncTime;
        this.lastValidatedTime = lastValidatedTime;
        this.isCompliant = isCompliant;
        this.countryCode = countryCode;
        this.phoneNumber = phoneNumber;
        this.isAccRecEnabled = isAccRecEnabled;
        this.deviceUUID = deviceUUID;
        this.basePublicKey = basePublicKey;
        this.authenticationMethod = authenticationMethod;
        this.expiresOn = expiresOn;
        this.seedDekId = seedDekId;
        this.seed = seed;
        this.thirdPartyFactor = thirdPartyFactor;
        this.user = user;
        this.pushNotificationTarget = pushNotificationTarget;
        this.additionalAttributes = additionalAttributes;
        this.authenticationFactors = authenticationFactors;
        this.nonCompliances = nonCompliances;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * Unique identifier for the SCIM Resource as defined by the Service Provider. Each
         * representation of the Resource MUST include a non-empty id value. This identifier MUST be
         * unique across the Service Provider's entire set of Resources. It MUST be a stable,
         * non-reassignable identifier that does not change when the same Resource is returned in
         * subsequent requests. The value of the id attribute is always issued by the Service
         * Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved
         * keyword and MUST NOT be used in the unique identifier.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
         * mutability: readOnly - required: false - returned: always - type: string - uniqueness:
         * global
         */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * Unique identifier for the SCIM Resource as defined by the Service Provider. Each
         * representation of the Resource MUST include a non-empty id value. This identifier MUST be
         * unique across the Service Provider's entire set of Resources. It MUST be a stable,
         * non-reassignable identifier that does not change when the same Resource is returned in
         * subsequent requests. The value of the id attribute is always issued by the Service
         * Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved
         * keyword and MUST NOT be used in the unique identifier.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
         * mutability: readOnly - required: false - returned: always - type: string - uniqueness:
         * global
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /**
         * Unique OCI identifier for the SCIM Resource.
         *
         * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
         * mutability: immutable - required: false - returned: default - type: string - uniqueness:
         * global
         */
        @com.fasterxml.jackson.annotation.JsonProperty("ocid")
        private String ocid;

        /**
         * Unique OCI identifier for the SCIM Resource.
         *
         * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
         * mutability: immutable - required: false - returned: default - type: string - uniqueness:
         * global
         *
         * @param ocid the value to set
         * @return this builder
         */
        public Builder ocid(String ocid) {
            this.ocid = ocid;
            this.__explicitlySet__.add("ocid");
            return this;
        }
        /**
         * REQUIRED. The schemas attribute is an array of Strings which allows introspection of the
         * supported schema version for a SCIM representation as well any schema extensions
         * supported by that representation. Each String value must be a unique URI. This
         * specification defines URIs for User, Group, and a standard \\"enterprise\\" extension.
         * All representations of SCIM schema MUST include a non-zero value array with value(s) of
         * the URIs supported by that representation. Duplicate values MUST NOT be included. Value
         * order is not specified and MUST not impact behavior.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: true -
         * mutability: readWrite - required: true - returned: default - type: string - uniqueness:
         * none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("schemas")
        private java.util.List<String> schemas;

        /**
         * REQUIRED. The schemas attribute is an array of Strings which allows introspection of the
         * supported schema version for a SCIM representation as well any schema extensions
         * supported by that representation. Each String value must be a unique URI. This
         * specification defines URIs for User, Group, and a standard \\"enterprise\\" extension.
         * All representations of SCIM schema MUST include a non-zero value array with value(s) of
         * the URIs supported by that representation. Duplicate values MUST NOT be included. Value
         * order is not specified and MUST not impact behavior.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: true -
         * mutability: readWrite - required: true - returned: default - type: string - uniqueness:
         * none
         *
         * @param schemas the value to set
         * @return this builder
         */
        public Builder schemas(java.util.List<String> schemas) {
            this.schemas = schemas;
            this.__explicitlySet__.add("schemas");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("meta")
        private Meta meta;

        public Builder meta(Meta meta) {
            this.meta = meta;
            this.__explicitlySet__.add("meta");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("idcsCreatedBy")
        private IdcsCreatedBy idcsCreatedBy;

        public Builder idcsCreatedBy(IdcsCreatedBy idcsCreatedBy) {
            this.idcsCreatedBy = idcsCreatedBy;
            this.__explicitlySet__.add("idcsCreatedBy");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("idcsLastModifiedBy")
        private IdcsLastModifiedBy idcsLastModifiedBy;

        public Builder idcsLastModifiedBy(IdcsLastModifiedBy idcsLastModifiedBy) {
            this.idcsLastModifiedBy = idcsLastModifiedBy;
            this.__explicitlySet__.add("idcsLastModifiedBy");
            return this;
        }
        /**
         * Each value of this attribute specifies an operation that only an internal client may
         * perform on this particular resource.
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: true - mutability:
         * readOnly - required: false - returned: request - type: string - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("idcsPreventedOperations")
        private java.util.List<IdcsPreventedOperations> idcsPreventedOperations;

        /**
         * Each value of this attribute specifies an operation that only an internal client may
         * perform on this particular resource.
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: true - mutability:
         * readOnly - required: false - returned: request - type: string - uniqueness: none
         *
         * @param idcsPreventedOperations the value to set
         * @return this builder
         */
        public Builder idcsPreventedOperations(
                java.util.List<IdcsPreventedOperations> idcsPreventedOperations) {
            this.idcsPreventedOperations = idcsPreventedOperations;
            this.__explicitlySet__.add("idcsPreventedOperations");
            return this;
        }
        /**
         * A list of tags on this resource.
         *
         * <p>*SCIM++ Properties:** - idcsCompositeKey: [key, value] - idcsSearchable: true -
         * multiValued: true - mutability: readWrite - required: false - returned: request - type:
         * complex - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("tags")
        private java.util.List<Tags> tags;

        /**
         * A list of tags on this resource.
         *
         * <p>*SCIM++ Properties:** - idcsCompositeKey: [key, value] - idcsSearchable: true -
         * multiValued: true - mutability: readWrite - required: false - returned: request - type:
         * complex - uniqueness: none
         *
         * @param tags the value to set
         * @return this builder
         */
        public Builder tags(java.util.List<Tags> tags) {
            this.tags = tags;
            this.__explicitlySet__.add("tags");
            return this;
        }
        /**
         * A boolean flag indicating this resource in the process of being deleted. Usually set to
         * true when synchronous deletion of the resource would take too long.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
         * mutability: readOnly - required: false - returned: default - type: boolean - uniqueness:
         * none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("deleteInProgress")
        private Boolean deleteInProgress;

        /**
         * A boolean flag indicating this resource in the process of being deleted. Usually set to
         * true when synchronous deletion of the resource would take too long.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
         * mutability: readOnly - required: false - returned: default - type: boolean - uniqueness:
         * none
         *
         * @param deleteInProgress the value to set
         * @return this builder
         */
        public Builder deleteInProgress(Boolean deleteInProgress) {
            this.deleteInProgress = deleteInProgress;
            this.__explicitlySet__.add("deleteInProgress");
            return this;
        }
        /**
         * The release number when the resource was upgraded.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false
         * - mutability: readOnly - required: false - returned: request - type: string - uniqueness:
         * none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("idcsLastUpgradedInRelease")
        private String idcsLastUpgradedInRelease;

        /**
         * The release number when the resource was upgraded.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false
         * - mutability: readOnly - required: false - returned: request - type: string - uniqueness:
         * none
         *
         * @param idcsLastUpgradedInRelease the value to set
         * @return this builder
         */
        public Builder idcsLastUpgradedInRelease(String idcsLastUpgradedInRelease) {
            this.idcsLastUpgradedInRelease = idcsLastUpgradedInRelease;
            this.__explicitlySet__.add("idcsLastUpgradedInRelease");
            return this;
        }
        /**
         * OCI Domain Id (ocid) in which the resource lives.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false
         * - mutability: readOnly - required: false - returned: default - type: string - uniqueness:
         * none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("domainOcid")
        private String domainOcid;

        /**
         * OCI Domain Id (ocid) in which the resource lives.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false
         * - mutability: readOnly - required: false - returned: default - type: string - uniqueness:
         * none
         *
         * @param domainOcid the value to set
         * @return this builder
         */
        public Builder domainOcid(String domainOcid) {
            this.domainOcid = domainOcid;
            this.__explicitlySet__.add("domainOcid");
            return this;
        }
        /**
         * OCI Compartment Id (ocid) in which the resource lives.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false
         * - mutability: readOnly - required: false - returned: default - type: string - uniqueness:
         * none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentOcid")
        private String compartmentOcid;

        /**
         * OCI Compartment Id (ocid) in which the resource lives.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false
         * - mutability: readOnly - required: false - returned: default - type: string - uniqueness:
         * none
         *
         * @param compartmentOcid the value to set
         * @return this builder
         */
        public Builder compartmentOcid(String compartmentOcid) {
            this.compartmentOcid = compartmentOcid;
            this.__explicitlySet__.add("compartmentOcid");
            return this;
        }
        /**
         * OCI Tenant Id (ocid) in which the resource lives.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false
         * - mutability: readOnly - required: false - returned: default - type: string - uniqueness:
         * none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("tenancyOcid")
        private String tenancyOcid;

        /**
         * OCI Tenant Id (ocid) in which the resource lives.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false
         * - mutability: readOnly - required: false - returned: default - type: string - uniqueness:
         * none
         *
         * @param tenancyOcid the value to set
         * @return this builder
         */
        public Builder tenancyOcid(String tenancyOcid) {
            this.tenancyOcid = tenancyOcid;
            this.__explicitlySet__.add("tenancyOcid");
            return this;
        }
        /**
         * An identifier for the Resource as defined by the Service Consumer. The externalId may
         * simplify identification of the Resource between Service Consumer and Service Provider by
         * allowing the Consumer to refer to the Resource with its own identifier, obviating the
         * need to store a local mapping between the local identifier of the Resource and the
         * identifier used by the Service Provider. Each Resource MAY include a non-empty externalId
         * value. The value of the externalId attribute is always issued be the Service Consumer and
         * can never be specified by the Service Provider. The Service Provider MUST always
         * interpret the externalId as scoped to the Service Consumer's tenant.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite
         * - required: false - returned: default - type: string - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("externalId")
        private String externalId;

        /**
         * An identifier for the Resource as defined by the Service Consumer. The externalId may
         * simplify identification of the Resource between Service Consumer and Service Provider by
         * allowing the Consumer to refer to the Resource with its own identifier, obviating the
         * need to store a local mapping between the local identifier of the Resource and the
         * identifier used by the Service Provider. Each Resource MAY include a non-empty externalId
         * value. The value of the externalId attribute is always issued be the Service Consumer and
         * can never be specified by the Service Provider. The Service Provider MUST always
         * interpret the externalId as scoped to the Service Consumer's tenant.
         *
         * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite
         * - required: false - returned: default - type: string - uniqueness: none
         *
         * @param externalId the value to set
         * @return this builder
         */
        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.__explicitlySet__.add("externalId");
            return this;
        }
        /**
         * Device friendly display name
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
         * mutability: readWrite - required: false - returned: default - type: string - uniqueness:
         * none - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * Device friendly display name
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
         * mutability: readWrite - required: false - returned: default - type: string - uniqueness:
         * none - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }
        /**
         * Device Platform
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * immutable - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true - required: false - returned:
         * default - type: string - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("platform")
        private Platform platform;

        /**
         * Device Platform
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * immutable - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true - required: false - returned:
         * default - type: string - uniqueness: none
         *
         * @param platform the value to set
         * @return this builder
         */
        public Builder platform(Platform platform) {
            this.platform = platform;
            this.__explicitlySet__.add("platform");
            return this;
        }
        /**
         * Device Status
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
         * mutability: readWrite - required: false - returned: default - type: string - uniqueness:
         * none - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("status")
        private Status status;

        /**
         * Device Status
         *
         * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
         * mutability: readWrite - required: false - returned: default - type: string - uniqueness:
         * none - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param status the value to set
         * @return this builder
         */
        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }
        /**
         * Additional comments/reasons for the change in device status
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readWrite - required: false - returned: default - type: string - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("reason")
        private String reason;

        /**
         * Additional comments/reasons for the change in device status
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readWrite - required: false - returned: default - type: string - uniqueness: none
         *
         * @param reason the value to set
         * @return this builder
         */
        public Builder reason(String reason) {
            this.reason = reason;
            this.__explicitlySet__.add("reason");
            return this;
        }
        /**
         * Device hardware name/model
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("deviceType")
        private String deviceType;

        /**
         * Device hardware name/model
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param deviceType the value to set
         * @return this builder
         */
        public Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            this.__explicitlySet__.add("deviceType");
            return this;
        }
        /**
         * Mobile Authenticator App Version
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("appVersion")
        private String appVersion;

        /**
         * Mobile Authenticator App Version
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param appVersion the value to set
         * @return this builder
         */
        public Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            this.__explicitlySet__.add("appVersion");
            return this;
        }
        /**
         * Mobile Authenticator App Package Id
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("packageId")
        private String packageId;

        /**
         * Mobile Authenticator App Package Id
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param packageId the value to set
         * @return this builder
         */
        public Builder packageId(String packageId) {
            this.packageId = packageId;
            this.__explicitlySet__.add("packageId");
            return this;
        }
        /**
         * Last Sync time for device
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: true - multiValued: false - mutability:
         * readWrite - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true - required: false - returned:
         * default - type: dateTime - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("lastSyncTime")
        private String lastSyncTime;

        /**
         * Last Sync time for device
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: true - multiValued: false - mutability:
         * readWrite - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true - required: false - returned:
         * default - type: dateTime - uniqueness: none
         *
         * @param lastSyncTime the value to set
         * @return this builder
         */
        public Builder lastSyncTime(String lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
            this.__explicitlySet__.add("lastSyncTime");
            return this;
        }
        /**
         * The most recent timestamp when the device was successfully validated using one time
         * passcode
         *
         * <p>*Added In:** 17.3.6
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - idcsAllowUpdatesInReadOnlyMode: true -
         * multiValued: false - mutability: readWrite - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true - required: false - returned:
         * default - type: dateTime - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("lastValidatedTime")
        private String lastValidatedTime;

        /**
         * The most recent timestamp when the device was successfully validated using one time
         * passcode
         *
         * <p>*Added In:** 17.3.6
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - idcsAllowUpdatesInReadOnlyMode: true -
         * multiValued: false - mutability: readWrite - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true - required: false - returned:
         * default - type: dateTime - uniqueness: none
         *
         * @param lastValidatedTime the value to set
         * @return this builder
         */
        public Builder lastValidatedTime(String lastValidatedTime) {
            this.lastValidatedTime = lastValidatedTime;
            this.__explicitlySet__.add("lastValidatedTime");
            return this;
        }
        /**
         * Device Compliance Status
         *
         * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
         * mutability: readOnly - required: false - returned: default - type: boolean - uniqueness:
         * none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("isCompliant")
        private Boolean isCompliant;

        /**
         * Device Compliance Status
         *
         * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
         * mutability: readOnly - required: false - returned: default - type: boolean - uniqueness:
         * none
         *
         * @param isCompliant the value to set
         * @return this builder
         */
        public Builder isCompliant(Boolean isCompliant) {
            this.isCompliant = isCompliant;
            this.__explicitlySet__.add("isCompliant");
            return this;
        }
        /**
         * Country code of user's Phone Number
         *
         * <p>*Added In:** 19.1.4
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * immutable - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("countryCode")
        private String countryCode;

        /**
         * Country code of user's Phone Number
         *
         * <p>*Added In:** 19.1.4
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * immutable - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param countryCode the value to set
         * @return this builder
         */
        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            this.__explicitlySet__.add("countryCode");
            return this;
        }
        /**
         * User's Phone Number
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * immutable - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("phoneNumber")
        private String phoneNumber;

        /**
         * User's Phone Number
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * immutable - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param phoneNumber the value to set
         * @return this builder
         */
        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.__explicitlySet__.add("phoneNumber");
            return this;
        }
        /**
         * Flag that indicates whether the device is enrolled for account recovery
         *
         * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
         * mutability: readWrite - required: false - returned: default - type: boolean - uniqueness:
         * none - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("isAccRecEnabled")
        private Boolean isAccRecEnabled;

        /**
         * Flag that indicates whether the device is enrolled for account recovery
         *
         * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
         * mutability: readWrite - required: false - returned: default - type: boolean - uniqueness:
         * none - idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param isAccRecEnabled the value to set
         * @return this builder
         */
        public Builder isAccRecEnabled(Boolean isAccRecEnabled) {
            this.isAccRecEnabled = isAccRecEnabled;
            this.__explicitlySet__.add("isAccRecEnabled");
            return this;
        }
        /**
         * Unique id sent from device
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("deviceUUID")
        private String deviceUUID;

        /**
         * Unique id sent from device
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param deviceUUID the value to set
         * @return this builder
         */
        public Builder deviceUUID(String deviceUUID) {
            this.deviceUUID = deviceUUID;
            this.__explicitlySet__.add("deviceUUID");
            return this;
        }
        /**
         * Device base public Key
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("basePublicKey")
        private String basePublicKey;

        /**
         * Device base public Key
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readOnly - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param basePublicKey the value to set
         * @return this builder
         */
        public Builder basePublicKey(String basePublicKey) {
            this.basePublicKey = basePublicKey;
            this.__explicitlySet__.add("basePublicKey");
            return this;
        }
        /**
         * Authentication method used in device. For FIDO, it will contain
         * SECURITY_KEY/WINDOWS_HELLO etc
         *
         * <p>*Added In:** 2009232244
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readWrite - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         */
        @com.fasterxml.jackson.annotation.JsonProperty("authenticationMethod")
        private String authenticationMethod;

        /**
         * Authentication method used in device. For FIDO, it will contain
         * SECURITY_KEY/WINDOWS_HELLO etc
         *
         * <p>*Added In:** 2009232244
         *
         * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability:
         * readWrite - required: false - returned: default - type: string - uniqueness: none -
         * idcsRequiresWriteForAccessFlows: true -
         * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
         *
         * @param authenticationMethod the value to set
         * @return this builder
         */
        public Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.__explicitlySet__.add("authenticationMethod");
            return this;
        }
        /**
         * Attribute added for replication log, it is not used by IDCS, just added as place holder
         *
         * <p>*Added In:** 2111040242
         *
         * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite
         * - required: false - returned: default - type: integer - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("expiresOn")
        private Integer expiresOn;

        /**
         * Attribute added for replication log, it is not used by IDCS, just added as place holder
         *
         * <p>*Added In:** 2111040242
         *
         * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite
         * - required: false - returned: default - type: integer - uniqueness: none
         *
         * @param expiresOn the value to set
         * @return this builder
         */
        public Builder expiresOn(Integer expiresOn) {
            this.expiresOn = expiresOn;
            this.__explicitlySet__.add("expiresOn");
            return this;
        }
        /**
         * Attribute added for replication log, it is not used by IDCS, the DEK that encrypts the
         * specific seed for that user
         *
         * <p>*Added In:** 2111040242
         *
         * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite
         * - required: false - returned: default - type: string - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("seedDekId")
        private String seedDekId;

        /**
         * Attribute added for replication log, it is not used by IDCS, the DEK that encrypts the
         * specific seed for that user
         *
         * <p>*Added In:** 2111040242
         *
         * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite
         * - required: false - returned: default - type: string - uniqueness: none
         *
         * @param seedDekId the value to set
         * @return this builder
         */
        public Builder seedDekId(String seedDekId) {
            this.seedDekId = seedDekId;
            this.__explicitlySet__.add("seedDekId");
            return this;
        }
        /**
         * Attribute added for replication log, it is not used by IDCS, it is actual encrypted TOTP
         * seed for the user
         *
         * <p>*Added In:** 2111040242
         *
         * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite
         * - required: false - returned: default - type: string - uniqueness: none
         */
        @com.fasterxml.jackson.annotation.JsonProperty("seed")
        private String seed;

        /**
         * Attribute added for replication log, it is not used by IDCS, it is actual encrypted TOTP
         * seed for the user
         *
         * <p>*Added In:** 2111040242
         *
         * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite
         * - required: false - returned: default - type: string - uniqueness: none
         *
         * @param seed the value to set
         * @return this builder
         */
        public Builder seed(String seed) {
            this.seed = seed;
            this.__explicitlySet__.add("seed");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("thirdPartyFactor")
        private MyDeviceThirdPartyFactor thirdPartyFactor;

        public Builder thirdPartyFactor(MyDeviceThirdPartyFactor thirdPartyFactor) {
            this.thirdPartyFactor = thirdPartyFactor;
            this.__explicitlySet__.add("thirdPartyFactor");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("user")
        private MyDeviceUser user;

        public Builder user(MyDeviceUser user) {
            this.user = user;
            this.__explicitlySet__.add("user");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("pushNotificationTarget")
        private MyDevicePushNotificationTarget pushNotificationTarget;

        public Builder pushNotificationTarget(
                MyDevicePushNotificationTarget pushNotificationTarget) {
            this.pushNotificationTarget = pushNotificationTarget;
            this.__explicitlySet__.add("pushNotificationTarget");
            return this;
        }
        /**
         * Device additional attributes
         *
         * <p>*SCIM++ Properties:** - idcsCompositeKey: [key, value] - idcsSearchable: false -
         * multiValued: true - mutability: readOnly - required: false - returned: default - type:
         * complex
         */
        @com.fasterxml.jackson.annotation.JsonProperty("additionalAttributes")
        private java.util.List<MyDeviceAdditionalAttributes> additionalAttributes;

        /**
         * Device additional attributes
         *
         * <p>*SCIM++ Properties:** - idcsCompositeKey: [key, value] - idcsSearchable: false -
         * multiValued: true - mutability: readOnly - required: false - returned: default - type:
         * complex
         *
         * @param additionalAttributes the value to set
         * @return this builder
         */
        public Builder additionalAttributes(
                java.util.List<MyDeviceAdditionalAttributes> additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            this.__explicitlySet__.add("additionalAttributes");
            return this;
        }
        /**
         * Authentication Factors
         *
         * <p>*SCIM++ Properties:** - caseExact: true - idcsCompositeKey: [type] - idcsSearchable:
         * true - multiValued: true - mutability: readWrite - required: true - returned: default -
         * type: complex
         */
        @com.fasterxml.jackson.annotation.JsonProperty("authenticationFactors")
        private java.util.List<MyDeviceAuthenticationFactors> authenticationFactors;

        /**
         * Authentication Factors
         *
         * <p>*SCIM++ Properties:** - caseExact: true - idcsCompositeKey: [type] - idcsSearchable:
         * true - multiValued: true - mutability: readWrite - required: true - returned: default -
         * type: complex
         *
         * @param authenticationFactors the value to set
         * @return this builder
         */
        public Builder authenticationFactors(
                java.util.List<MyDeviceAuthenticationFactors> authenticationFactors) {
            this.authenticationFactors = authenticationFactors;
            this.__explicitlySet__.add("authenticationFactors");
            return this;
        }
        /**
         * Device Non Compliances
         *
         * <p>*SCIM++ Properties:** - idcsCompositeKey: [name, value] - idcsSearchable: false -
         * multiValued: true - mutability: readOnly - required: false - returned: default - type:
         * complex
         */
        @com.fasterxml.jackson.annotation.JsonProperty("nonCompliances")
        private java.util.List<MyDeviceNonCompliances> nonCompliances;

        /**
         * Device Non Compliances
         *
         * <p>*SCIM++ Properties:** - idcsCompositeKey: [name, value] - idcsSearchable: false -
         * multiValued: true - mutability: readOnly - required: false - returned: default - type:
         * complex
         *
         * @param nonCompliances the value to set
         * @return this builder
         */
        public Builder nonCompliances(java.util.List<MyDeviceNonCompliances> nonCompliances) {
            this.nonCompliances = nonCompliances;
            this.__explicitlySet__.add("nonCompliances");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public MyDevice build() {
            MyDevice model =
                    new MyDevice(
                            this.id,
                            this.ocid,
                            this.schemas,
                            this.meta,
                            this.idcsCreatedBy,
                            this.idcsLastModifiedBy,
                            this.idcsPreventedOperations,
                            this.tags,
                            this.deleteInProgress,
                            this.idcsLastUpgradedInRelease,
                            this.domainOcid,
                            this.compartmentOcid,
                            this.tenancyOcid,
                            this.externalId,
                            this.displayName,
                            this.platform,
                            this.status,
                            this.reason,
                            this.deviceType,
                            this.appVersion,
                            this.packageId,
                            this.lastSyncTime,
                            this.lastValidatedTime,
                            this.isCompliant,
                            this.countryCode,
                            this.phoneNumber,
                            this.isAccRecEnabled,
                            this.deviceUUID,
                            this.basePublicKey,
                            this.authenticationMethod,
                            this.expiresOn,
                            this.seedDekId,
                            this.seed,
                            this.thirdPartyFactor,
                            this.user,
                            this.pushNotificationTarget,
                            this.additionalAttributes,
                            this.authenticationFactors,
                            this.nonCompliances);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(MyDevice model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("ocid")) {
                this.ocid(model.getOcid());
            }
            if (model.wasPropertyExplicitlySet("schemas")) {
                this.schemas(model.getSchemas());
            }
            if (model.wasPropertyExplicitlySet("meta")) {
                this.meta(model.getMeta());
            }
            if (model.wasPropertyExplicitlySet("idcsCreatedBy")) {
                this.idcsCreatedBy(model.getIdcsCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("idcsLastModifiedBy")) {
                this.idcsLastModifiedBy(model.getIdcsLastModifiedBy());
            }
            if (model.wasPropertyExplicitlySet("idcsPreventedOperations")) {
                this.idcsPreventedOperations(model.getIdcsPreventedOperations());
            }
            if (model.wasPropertyExplicitlySet("tags")) {
                this.tags(model.getTags());
            }
            if (model.wasPropertyExplicitlySet("deleteInProgress")) {
                this.deleteInProgress(model.getDeleteInProgress());
            }
            if (model.wasPropertyExplicitlySet("idcsLastUpgradedInRelease")) {
                this.idcsLastUpgradedInRelease(model.getIdcsLastUpgradedInRelease());
            }
            if (model.wasPropertyExplicitlySet("domainOcid")) {
                this.domainOcid(model.getDomainOcid());
            }
            if (model.wasPropertyExplicitlySet("compartmentOcid")) {
                this.compartmentOcid(model.getCompartmentOcid());
            }
            if (model.wasPropertyExplicitlySet("tenancyOcid")) {
                this.tenancyOcid(model.getTenancyOcid());
            }
            if (model.wasPropertyExplicitlySet("externalId")) {
                this.externalId(model.getExternalId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("platform")) {
                this.platform(model.getPlatform());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("reason")) {
                this.reason(model.getReason());
            }
            if (model.wasPropertyExplicitlySet("deviceType")) {
                this.deviceType(model.getDeviceType());
            }
            if (model.wasPropertyExplicitlySet("appVersion")) {
                this.appVersion(model.getAppVersion());
            }
            if (model.wasPropertyExplicitlySet("packageId")) {
                this.packageId(model.getPackageId());
            }
            if (model.wasPropertyExplicitlySet("lastSyncTime")) {
                this.lastSyncTime(model.getLastSyncTime());
            }
            if (model.wasPropertyExplicitlySet("lastValidatedTime")) {
                this.lastValidatedTime(model.getLastValidatedTime());
            }
            if (model.wasPropertyExplicitlySet("isCompliant")) {
                this.isCompliant(model.getIsCompliant());
            }
            if (model.wasPropertyExplicitlySet("countryCode")) {
                this.countryCode(model.getCountryCode());
            }
            if (model.wasPropertyExplicitlySet("phoneNumber")) {
                this.phoneNumber(model.getPhoneNumber());
            }
            if (model.wasPropertyExplicitlySet("isAccRecEnabled")) {
                this.isAccRecEnabled(model.getIsAccRecEnabled());
            }
            if (model.wasPropertyExplicitlySet("deviceUUID")) {
                this.deviceUUID(model.getDeviceUUID());
            }
            if (model.wasPropertyExplicitlySet("basePublicKey")) {
                this.basePublicKey(model.getBasePublicKey());
            }
            if (model.wasPropertyExplicitlySet("authenticationMethod")) {
                this.authenticationMethod(model.getAuthenticationMethod());
            }
            if (model.wasPropertyExplicitlySet("expiresOn")) {
                this.expiresOn(model.getExpiresOn());
            }
            if (model.wasPropertyExplicitlySet("seedDekId")) {
                this.seedDekId(model.getSeedDekId());
            }
            if (model.wasPropertyExplicitlySet("seed")) {
                this.seed(model.getSeed());
            }
            if (model.wasPropertyExplicitlySet("thirdPartyFactor")) {
                this.thirdPartyFactor(model.getThirdPartyFactor());
            }
            if (model.wasPropertyExplicitlySet("user")) {
                this.user(model.getUser());
            }
            if (model.wasPropertyExplicitlySet("pushNotificationTarget")) {
                this.pushNotificationTarget(model.getPushNotificationTarget());
            }
            if (model.wasPropertyExplicitlySet("additionalAttributes")) {
                this.additionalAttributes(model.getAdditionalAttributes());
            }
            if (model.wasPropertyExplicitlySet("authenticationFactors")) {
                this.authenticationFactors(model.getAuthenticationFactors());
            }
            if (model.wasPropertyExplicitlySet("nonCompliances")) {
                this.nonCompliances(model.getNonCompliances());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * Unique identifier for the SCIM Resource as defined by the Service Provider. Each
     * representation of the Resource MUST include a non-empty id value. This identifier MUST be
     * unique across the Service Provider's entire set of Resources. It MUST be a stable,
     * non-reassignable identifier that does not change when the same Resource is returned in
     * subsequent requests. The value of the id attribute is always issued by the Service Provider
     * and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST
     * NOT be used in the unique identifier.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
     * mutability: readOnly - required: false - returned: always - type: string - uniqueness: global
     */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * Unique identifier for the SCIM Resource as defined by the Service Provider. Each
     * representation of the Resource MUST include a non-empty id value. This identifier MUST be
     * unique across the Service Provider's entire set of Resources. It MUST be a stable,
     * non-reassignable identifier that does not change when the same Resource is returned in
     * subsequent requests. The value of the id attribute is always issued by the Service Provider
     * and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST
     * NOT be used in the unique identifier.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
     * mutability: readOnly - required: false - returned: always - type: string - uniqueness: global
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /**
     * Unique OCI identifier for the SCIM Resource.
     *
     * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
     * mutability: immutable - required: false - returned: default - type: string - uniqueness:
     * global
     */
    @com.fasterxml.jackson.annotation.JsonProperty("ocid")
    private final String ocid;

    /**
     * Unique OCI identifier for the SCIM Resource.
     *
     * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
     * mutability: immutable - required: false - returned: default - type: string - uniqueness:
     * global
     *
     * @return the value
     */
    public String getOcid() {
        return ocid;
    }

    /**
     * REQUIRED. The schemas attribute is an array of Strings which allows introspection of the
     * supported schema version for a SCIM representation as well any schema extensions supported by
     * that representation. Each String value must be a unique URI. This specification defines URIs
     * for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM
     * schema MUST include a non-zero value array with value(s) of the URIs supported by that
     * representation. Duplicate values MUST NOT be included. Value order is not specified and MUST
     * not impact behavior.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: true -
     * mutability: readWrite - required: true - returned: default - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("schemas")
    private final java.util.List<String> schemas;

    /**
     * REQUIRED. The schemas attribute is an array of Strings which allows introspection of the
     * supported schema version for a SCIM representation as well any schema extensions supported by
     * that representation. Each String value must be a unique URI. This specification defines URIs
     * for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM
     * schema MUST include a non-zero value array with value(s) of the URIs supported by that
     * representation. Duplicate values MUST NOT be included. Value order is not specified and MUST
     * not impact behavior.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: true -
     * mutability: readWrite - required: true - returned: default - type: string - uniqueness: none
     *
     * @return the value
     */
    public java.util.List<String> getSchemas() {
        return schemas;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("meta")
    private final Meta meta;

    public Meta getMeta() {
        return meta;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("idcsCreatedBy")
    private final IdcsCreatedBy idcsCreatedBy;

    public IdcsCreatedBy getIdcsCreatedBy() {
        return idcsCreatedBy;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("idcsLastModifiedBy")
    private final IdcsLastModifiedBy idcsLastModifiedBy;

    public IdcsLastModifiedBy getIdcsLastModifiedBy() {
        return idcsLastModifiedBy;
    }

    /**
     * Each value of this attribute specifies an operation that only an internal client may perform
     * on this particular resource.
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: true - mutability: readOnly -
     * required: false - returned: request - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("idcsPreventedOperations")
    private final java.util.List<IdcsPreventedOperations> idcsPreventedOperations;

    /**
     * Each value of this attribute specifies an operation that only an internal client may perform
     * on this particular resource.
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: true - mutability: readOnly -
     * required: false - returned: request - type: string - uniqueness: none
     *
     * @return the value
     */
    public java.util.List<IdcsPreventedOperations> getIdcsPreventedOperations() {
        return idcsPreventedOperations;
    }

    /**
     * A list of tags on this resource.
     *
     * <p>*SCIM++ Properties:** - idcsCompositeKey: [key, value] - idcsSearchable: true -
     * multiValued: true - mutability: readWrite - required: false - returned: request - type:
     * complex - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("tags")
    private final java.util.List<Tags> tags;

    /**
     * A list of tags on this resource.
     *
     * <p>*SCIM++ Properties:** - idcsCompositeKey: [key, value] - idcsSearchable: true -
     * multiValued: true - mutability: readWrite - required: false - returned: request - type:
     * complex - uniqueness: none
     *
     * @return the value
     */
    public java.util.List<Tags> getTags() {
        return tags;
    }

    /**
     * A boolean flag indicating this resource in the process of being deleted. Usually set to true
     * when synchronous deletion of the resource would take too long.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: boolean - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("deleteInProgress")
    private final Boolean deleteInProgress;

    /**
     * A boolean flag indicating this resource in the process of being deleted. Usually set to true
     * when synchronous deletion of the resource would take too long.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: boolean - uniqueness: none
     *
     * @return the value
     */
    public Boolean getDeleteInProgress() {
        return deleteInProgress;
    }

    /**
     * The release number when the resource was upgraded.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false -
     * mutability: readOnly - required: false - returned: request - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("idcsLastUpgradedInRelease")
    private final String idcsLastUpgradedInRelease;

    /**
     * The release number when the resource was upgraded.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false -
     * mutability: readOnly - required: false - returned: request - type: string - uniqueness: none
     *
     * @return the value
     */
    public String getIdcsLastUpgradedInRelease() {
        return idcsLastUpgradedInRelease;
    }

    /**
     * OCI Domain Id (ocid) in which the resource lives.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("domainOcid")
    private final String domainOcid;

    /**
     * OCI Domain Id (ocid) in which the resource lives.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: string - uniqueness: none
     *
     * @return the value
     */
    public String getDomainOcid() {
        return domainOcid;
    }

    /**
     * OCI Compartment Id (ocid) in which the resource lives.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentOcid")
    private final String compartmentOcid;

    /**
     * OCI Compartment Id (ocid) in which the resource lives.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: string - uniqueness: none
     *
     * @return the value
     */
    public String getCompartmentOcid() {
        return compartmentOcid;
    }

    /**
     * OCI Tenant Id (ocid) in which the resource lives.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("tenancyOcid")
    private final String tenancyOcid;

    /**
     * OCI Tenant Id (ocid) in which the resource lives.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: string - uniqueness: none
     *
     * @return the value
     */
    public String getTenancyOcid() {
        return tenancyOcid;
    }

    /**
     * An identifier for the Resource as defined by the Service Consumer. The externalId may
     * simplify identification of the Resource between Service Consumer and Service Provider by
     * allowing the Consumer to refer to the Resource with its own identifier, obviating the need to
     * store a local mapping between the local identifier of the Resource and the identifier used by
     * the Service Provider. Each Resource MAY include a non-empty externalId value. The value of
     * the externalId attribute is always issued be the Service Consumer and can never be specified
     * by the Service Provider. The Service Provider MUST always interpret the externalId as scoped
     * to the Service Consumer's tenant.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite -
     * required: false - returned: default - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("externalId")
    private final String externalId;

    /**
     * An identifier for the Resource as defined by the Service Consumer. The externalId may
     * simplify identification of the Resource between Service Consumer and Service Provider by
     * allowing the Consumer to refer to the Resource with its own identifier, obviating the need to
     * store a local mapping between the local identifier of the Resource and the identifier used by
     * the Service Provider. Each Resource MAY include a non-empty externalId value. The value of
     * the externalId attribute is always issued be the Service Consumer and can never be specified
     * by the Service Provider. The Service Provider MUST always interpret the externalId as scoped
     * to the Service Consumer's tenant.
     *
     * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite -
     * required: false - returned: default - type: string - uniqueness: none
     *
     * @return the value
     */
    public String getExternalId() {
        return externalId;
    }

    /**
     * Device friendly display name
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
     * mutability: readWrite - required: false - returned: default - type: string - uniqueness: none
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * Device friendly display name
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
     * mutability: readWrite - required: false - returned: default - type: string - uniqueness: none
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * Device Platform
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: immutable
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true - required: false - returned: default - type: string - uniqueness: none
     */
    public enum Platform implements com.oracle.bmc.http.internal.BmcEnum {
        Ios("IOS"),
        Android("ANDROID"),
        Windows("WINDOWS"),
        Cellular("CELLULAR"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG =
                org.slf4j.LoggerFactory.getLogger(Platform.class);

        private final String value;
        private static java.util.Map<String, Platform> map;

        static {
            map = new java.util.HashMap<>();
            for (Platform v : Platform.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        Platform(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static Platform create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'Platform', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /**
     * Device Platform
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: immutable
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true - required: false - returned: default - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("platform")
    private final Platform platform;

    /**
     * Device Platform
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: immutable
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true - required: false - returned: default - type: string - uniqueness: none
     *
     * @return the value
     */
    public Platform getPlatform() {
        return platform;
    }

    /**
     * Device Status
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
     * mutability: readWrite - required: false - returned: default - type: string - uniqueness: none
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    public enum Status implements com.oracle.bmc.http.internal.BmcEnum {
        Initiated("INITIATED"),
        Inprogress("INPROGRESS"),
        Inactive("INACTIVE"),
        Enrolled("ENROLLED"),
        Locked("LOCKED"),
        Blocked("BLOCKED"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG = org.slf4j.LoggerFactory.getLogger(Status.class);

        private final String value;
        private static java.util.Map<String, Status> map;

        static {
            map = new java.util.HashMap<>();
            for (Status v : Status.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        Status(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'Status', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /**
     * Device Status
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
     * mutability: readWrite - required: false - returned: default - type: string - uniqueness: none
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("status")
    private final Status status;

    /**
     * Device Status
     *
     * <p>*SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false -
     * mutability: readWrite - required: false - returned: default - type: string - uniqueness: none
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public Status getStatus() {
        return status;
    }

    /**
     * Additional comments/reasons for the change in device status
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readWrite
     * - required: false - returned: default - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("reason")
    private final String reason;

    /**
     * Additional comments/reasons for the change in device status
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readWrite
     * - required: false - returned: default - type: string - uniqueness: none
     *
     * @return the value
     */
    public String getReason() {
        return reason;
    }

    /**
     * Device hardware name/model
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("deviceType")
    private final String deviceType;

    /**
     * Device hardware name/model
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public String getDeviceType() {
        return deviceType;
    }

    /**
     * Mobile Authenticator App Version
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("appVersion")
    private final String appVersion;

    /**
     * Mobile Authenticator App Version
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public String getAppVersion() {
        return appVersion;
    }

    /**
     * Mobile Authenticator App Package Id
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("packageId")
    private final String packageId;

    /**
     * Mobile Authenticator App Package Id
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public String getPackageId() {
        return packageId;
    }

    /**
     * Last Sync time for device
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: true - multiValued: false - mutability: readWrite
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true - required: false - returned: default - type: dateTime - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("lastSyncTime")
    private final String lastSyncTime;

    /**
     * Last Sync time for device
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: true - multiValued: false - mutability: readWrite
     * - idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true - required: false - returned: default - type: dateTime - uniqueness: none
     *
     * @return the value
     */
    public String getLastSyncTime() {
        return lastSyncTime;
    }

    /**
     * The most recent timestamp when the device was successfully validated using one time passcode
     *
     * <p>*Added In:** 17.3.6
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - idcsAllowUpdatesInReadOnlyMode: true -
     * multiValued: false - mutability: readWrite - idcsRequiresWriteForAccessFlows: true -
     * idcsRequiresImmediateReadAfterWriteForAccessFlows: true - required: false - returned: default
     * - type: dateTime - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("lastValidatedTime")
    private final String lastValidatedTime;

    /**
     * The most recent timestamp when the device was successfully validated using one time passcode
     *
     * <p>*Added In:** 17.3.6
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - idcsAllowUpdatesInReadOnlyMode: true -
     * multiValued: false - mutability: readWrite - idcsRequiresWriteForAccessFlows: true -
     * idcsRequiresImmediateReadAfterWriteForAccessFlows: true - required: false - returned: default
     * - type: dateTime - uniqueness: none
     *
     * @return the value
     */
    public String getLastValidatedTime() {
        return lastValidatedTime;
    }

    /**
     * Device Compliance Status
     *
     * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: boolean - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isCompliant")
    private final Boolean isCompliant;

    /**
     * Device Compliance Status
     *
     * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
     * mutability: readOnly - required: false - returned: default - type: boolean - uniqueness: none
     *
     * @return the value
     */
    public Boolean getIsCompliant() {
        return isCompliant;
    }

    /**
     * Country code of user's Phone Number
     *
     * <p>*Added In:** 19.1.4
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: immutable
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("countryCode")
    private final String countryCode;

    /**
     * Country code of user's Phone Number
     *
     * <p>*Added In:** 19.1.4
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: immutable
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /**
     * User's Phone Number
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: immutable
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("phoneNumber")
    private final String phoneNumber;

    /**
     * User's Phone Number
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: immutable
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Flag that indicates whether the device is enrolled for account recovery
     *
     * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
     * mutability: readWrite - required: false - returned: default - type: boolean - uniqueness:
     * none - idcsRequiresWriteForAccessFlows: true -
     * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isAccRecEnabled")
    private final Boolean isAccRecEnabled;

    /**
     * Flag that indicates whether the device is enrolled for account recovery
     *
     * <p>*SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false -
     * mutability: readWrite - required: false - returned: default - type: boolean - uniqueness:
     * none - idcsRequiresWriteForAccessFlows: true -
     * idcsRequiresImmediateReadAfterWriteForAccessFlows: true
     *
     * @return the value
     */
    public Boolean getIsAccRecEnabled() {
        return isAccRecEnabled;
    }

    /**
     * Unique id sent from device
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("deviceUUID")
    private final String deviceUUID;

    /**
     * Unique id sent from device
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public String getDeviceUUID() {
        return deviceUUID;
    }

    /**
     * Device base public Key
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("basePublicKey")
    private final String basePublicKey;

    /**
     * Device base public Key
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readOnly
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public String getBasePublicKey() {
        return basePublicKey;
    }

    /**
     * Authentication method used in device. For FIDO, it will contain SECURITY_KEY/WINDOWS_HELLO
     * etc
     *
     * <p>*Added In:** 2009232244
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readWrite
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     */
    @com.fasterxml.jackson.annotation.JsonProperty("authenticationMethod")
    private final String authenticationMethod;

    /**
     * Authentication method used in device. For FIDO, it will contain SECURITY_KEY/WINDOWS_HELLO
     * etc
     *
     * <p>*Added In:** 2009232244
     *
     * <p>*SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: readWrite
     * - required: false - returned: default - type: string - uniqueness: none -
     * idcsRequiresWriteForAccessFlows: true - idcsRequiresImmediateReadAfterWriteForAccessFlows:
     * true
     *
     * @return the value
     */
    public String getAuthenticationMethod() {
        return authenticationMethod;
    }

    /**
     * Attribute added for replication log, it is not used by IDCS, just added as place holder
     *
     * <p>*Added In:** 2111040242
     *
     * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite -
     * required: false - returned: default - type: integer - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("expiresOn")
    private final Integer expiresOn;

    /**
     * Attribute added for replication log, it is not used by IDCS, just added as place holder
     *
     * <p>*Added In:** 2111040242
     *
     * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite -
     * required: false - returned: default - type: integer - uniqueness: none
     *
     * @return the value
     */
    public Integer getExpiresOn() {
        return expiresOn;
    }

    /**
     * Attribute added for replication log, it is not used by IDCS, the DEK that encrypts the
     * specific seed for that user
     *
     * <p>*Added In:** 2111040242
     *
     * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite -
     * required: false - returned: default - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("seedDekId")
    private final String seedDekId;

    /**
     * Attribute added for replication log, it is not used by IDCS, the DEK that encrypts the
     * specific seed for that user
     *
     * <p>*Added In:** 2111040242
     *
     * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite -
     * required: false - returned: default - type: string - uniqueness: none
     *
     * @return the value
     */
    public String getSeedDekId() {
        return seedDekId;
    }

    /**
     * Attribute added for replication log, it is not used by IDCS, it is actual encrypted TOTP seed
     * for the user
     *
     * <p>*Added In:** 2111040242
     *
     * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite -
     * required: false - returned: default - type: string - uniqueness: none
     */
    @com.fasterxml.jackson.annotation.JsonProperty("seed")
    private final String seed;

    /**
     * Attribute added for replication log, it is not used by IDCS, it is actual encrypted TOTP seed
     * for the user
     *
     * <p>*Added In:** 2111040242
     *
     * <p>*SCIM++ Properties:** - caseExact: false - multiValued: false - mutability: readWrite -
     * required: false - returned: default - type: string - uniqueness: none
     *
     * @return the value
     */
    public String getSeed() {
        return seed;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("thirdPartyFactor")
    private final MyDeviceThirdPartyFactor thirdPartyFactor;

    public MyDeviceThirdPartyFactor getThirdPartyFactor() {
        return thirdPartyFactor;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("user")
    private final MyDeviceUser user;

    public MyDeviceUser getUser() {
        return user;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("pushNotificationTarget")
    private final MyDevicePushNotificationTarget pushNotificationTarget;

    public MyDevicePushNotificationTarget getPushNotificationTarget() {
        return pushNotificationTarget;
    }

    /**
     * Device additional attributes
     *
     * <p>*SCIM++ Properties:** - idcsCompositeKey: [key, value] - idcsSearchable: false -
     * multiValued: true - mutability: readOnly - required: false - returned: default - type:
     * complex
     */
    @com.fasterxml.jackson.annotation.JsonProperty("additionalAttributes")
    private final java.util.List<MyDeviceAdditionalAttributes> additionalAttributes;

    /**
     * Device additional attributes
     *
     * <p>*SCIM++ Properties:** - idcsCompositeKey: [key, value] - idcsSearchable: false -
     * multiValued: true - mutability: readOnly - required: false - returned: default - type:
     * complex
     *
     * @return the value
     */
    public java.util.List<MyDeviceAdditionalAttributes> getAdditionalAttributes() {
        return additionalAttributes;
    }

    /**
     * Authentication Factors
     *
     * <p>*SCIM++ Properties:** - caseExact: true - idcsCompositeKey: [type] - idcsSearchable: true
     * - multiValued: true - mutability: readWrite - required: true - returned: default - type:
     * complex
     */
    @com.fasterxml.jackson.annotation.JsonProperty("authenticationFactors")
    private final java.util.List<MyDeviceAuthenticationFactors> authenticationFactors;

    /**
     * Authentication Factors
     *
     * <p>*SCIM++ Properties:** - caseExact: true - idcsCompositeKey: [type] - idcsSearchable: true
     * - multiValued: true - mutability: readWrite - required: true - returned: default - type:
     * complex
     *
     * @return the value
     */
    public java.util.List<MyDeviceAuthenticationFactors> getAuthenticationFactors() {
        return authenticationFactors;
    }

    /**
     * Device Non Compliances
     *
     * <p>*SCIM++ Properties:** - idcsCompositeKey: [name, value] - idcsSearchable: false -
     * multiValued: true - mutability: readOnly - required: false - returned: default - type:
     * complex
     */
    @com.fasterxml.jackson.annotation.JsonProperty("nonCompliances")
    private final java.util.List<MyDeviceNonCompliances> nonCompliances;

    /**
     * Device Non Compliances
     *
     * <p>*SCIM++ Properties:** - idcsCompositeKey: [name, value] - idcsSearchable: false -
     * multiValued: true - mutability: readOnly - required: false - returned: default - type:
     * complex
     *
     * @return the value
     */
    public java.util.List<MyDeviceNonCompliances> getNonCompliances() {
        return nonCompliances;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("MyDevice(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", ocid=").append(String.valueOf(this.ocid));
        sb.append(", schemas=").append(String.valueOf(this.schemas));
        sb.append(", meta=").append(String.valueOf(this.meta));
        sb.append(", idcsCreatedBy=").append(String.valueOf(this.idcsCreatedBy));
        sb.append(", idcsLastModifiedBy=").append(String.valueOf(this.idcsLastModifiedBy));
        sb.append(", idcsPreventedOperations=")
                .append(String.valueOf(this.idcsPreventedOperations));
        sb.append(", tags=").append(String.valueOf(this.tags));
        sb.append(", deleteInProgress=").append(String.valueOf(this.deleteInProgress));
        sb.append(", idcsLastUpgradedInRelease=")
                .append(String.valueOf(this.idcsLastUpgradedInRelease));
        sb.append(", domainOcid=").append(String.valueOf(this.domainOcid));
        sb.append(", compartmentOcid=").append(String.valueOf(this.compartmentOcid));
        sb.append(", tenancyOcid=").append(String.valueOf(this.tenancyOcid));
        sb.append(", externalId=").append(String.valueOf(this.externalId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", platform=").append(String.valueOf(this.platform));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", reason=").append(String.valueOf(this.reason));
        sb.append(", deviceType=").append(String.valueOf(this.deviceType));
        sb.append(", appVersion=").append(String.valueOf(this.appVersion));
        sb.append(", packageId=").append(String.valueOf(this.packageId));
        sb.append(", lastSyncTime=").append(String.valueOf(this.lastSyncTime));
        sb.append(", lastValidatedTime=").append(String.valueOf(this.lastValidatedTime));
        sb.append(", isCompliant=").append(String.valueOf(this.isCompliant));
        sb.append(", countryCode=").append(String.valueOf(this.countryCode));
        sb.append(", phoneNumber=").append(String.valueOf(this.phoneNumber));
        sb.append(", isAccRecEnabled=").append(String.valueOf(this.isAccRecEnabled));
        sb.append(", deviceUUID=").append(String.valueOf(this.deviceUUID));
        sb.append(", basePublicKey=").append(String.valueOf(this.basePublicKey));
        sb.append(", authenticationMethod=").append(String.valueOf(this.authenticationMethod));
        sb.append(", expiresOn=").append(String.valueOf(this.expiresOn));
        sb.append(", seedDekId=").append(String.valueOf(this.seedDekId));
        sb.append(", seed=").append(String.valueOf(this.seed));
        sb.append(", thirdPartyFactor=").append(String.valueOf(this.thirdPartyFactor));
        sb.append(", user=").append(String.valueOf(this.user));
        sb.append(", pushNotificationTarget=").append(String.valueOf(this.pushNotificationTarget));
        sb.append(", additionalAttributes=").append(String.valueOf(this.additionalAttributes));
        sb.append(", authenticationFactors=").append(String.valueOf(this.authenticationFactors));
        sb.append(", nonCompliances=").append(String.valueOf(this.nonCompliances));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MyDevice)) {
            return false;
        }

        MyDevice other = (MyDevice) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.ocid, other.ocid)
                && java.util.Objects.equals(this.schemas, other.schemas)
                && java.util.Objects.equals(this.meta, other.meta)
                && java.util.Objects.equals(this.idcsCreatedBy, other.idcsCreatedBy)
                && java.util.Objects.equals(this.idcsLastModifiedBy, other.idcsLastModifiedBy)
                && java.util.Objects.equals(
                        this.idcsPreventedOperations, other.idcsPreventedOperations)
                && java.util.Objects.equals(this.tags, other.tags)
                && java.util.Objects.equals(this.deleteInProgress, other.deleteInProgress)
                && java.util.Objects.equals(
                        this.idcsLastUpgradedInRelease, other.idcsLastUpgradedInRelease)
                && java.util.Objects.equals(this.domainOcid, other.domainOcid)
                && java.util.Objects.equals(this.compartmentOcid, other.compartmentOcid)
                && java.util.Objects.equals(this.tenancyOcid, other.tenancyOcid)
                && java.util.Objects.equals(this.externalId, other.externalId)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.platform, other.platform)
                && java.util.Objects.equals(this.status, other.status)
                && java.util.Objects.equals(this.reason, other.reason)
                && java.util.Objects.equals(this.deviceType, other.deviceType)
                && java.util.Objects.equals(this.appVersion, other.appVersion)
                && java.util.Objects.equals(this.packageId, other.packageId)
                && java.util.Objects.equals(this.lastSyncTime, other.lastSyncTime)
                && java.util.Objects.equals(this.lastValidatedTime, other.lastValidatedTime)
                && java.util.Objects.equals(this.isCompliant, other.isCompliant)
                && java.util.Objects.equals(this.countryCode, other.countryCode)
                && java.util.Objects.equals(this.phoneNumber, other.phoneNumber)
                && java.util.Objects.equals(this.isAccRecEnabled, other.isAccRecEnabled)
                && java.util.Objects.equals(this.deviceUUID, other.deviceUUID)
                && java.util.Objects.equals(this.basePublicKey, other.basePublicKey)
                && java.util.Objects.equals(this.authenticationMethod, other.authenticationMethod)
                && java.util.Objects.equals(this.expiresOn, other.expiresOn)
                && java.util.Objects.equals(this.seedDekId, other.seedDekId)
                && java.util.Objects.equals(this.seed, other.seed)
                && java.util.Objects.equals(this.thirdPartyFactor, other.thirdPartyFactor)
                && java.util.Objects.equals(this.user, other.user)
                && java.util.Objects.equals(
                        this.pushNotificationTarget, other.pushNotificationTarget)
                && java.util.Objects.equals(this.additionalAttributes, other.additionalAttributes)
                && java.util.Objects.equals(this.authenticationFactors, other.authenticationFactors)
                && java.util.Objects.equals(this.nonCompliances, other.nonCompliances)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result = (result * PRIME) + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = (result * PRIME) + (this.schemas == null ? 43 : this.schemas.hashCode());
        result = (result * PRIME) + (this.meta == null ? 43 : this.meta.hashCode());
        result =
                (result * PRIME)
                        + (this.idcsCreatedBy == null ? 43 : this.idcsCreatedBy.hashCode());
        result =
                (result * PRIME)
                        + (this.idcsLastModifiedBy == null
                                ? 43
                                : this.idcsLastModifiedBy.hashCode());
        result =
                (result * PRIME)
                        + (this.idcsPreventedOperations == null
                                ? 43
                                : this.idcsPreventedOperations.hashCode());
        result = (result * PRIME) + (this.tags == null ? 43 : this.tags.hashCode());
        result =
                (result * PRIME)
                        + (this.deleteInProgress == null ? 43 : this.deleteInProgress.hashCode());
        result =
                (result * PRIME)
                        + (this.idcsLastUpgradedInRelease == null
                                ? 43
                                : this.idcsLastUpgradedInRelease.hashCode());
        result = (result * PRIME) + (this.domainOcid == null ? 43 : this.domainOcid.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentOcid == null ? 43 : this.compartmentOcid.hashCode());
        result = (result * PRIME) + (this.tenancyOcid == null ? 43 : this.tenancyOcid.hashCode());
        result = (result * PRIME) + (this.externalId == null ? 43 : this.externalId.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.platform == null ? 43 : this.platform.hashCode());
        result = (result * PRIME) + (this.status == null ? 43 : this.status.hashCode());
        result = (result * PRIME) + (this.reason == null ? 43 : this.reason.hashCode());
        result = (result * PRIME) + (this.deviceType == null ? 43 : this.deviceType.hashCode());
        result = (result * PRIME) + (this.appVersion == null ? 43 : this.appVersion.hashCode());
        result = (result * PRIME) + (this.packageId == null ? 43 : this.packageId.hashCode());
        result = (result * PRIME) + (this.lastSyncTime == null ? 43 : this.lastSyncTime.hashCode());
        result =
                (result * PRIME)
                        + (this.lastValidatedTime == null ? 43 : this.lastValidatedTime.hashCode());
        result = (result * PRIME) + (this.isCompliant == null ? 43 : this.isCompliant.hashCode());
        result = (result * PRIME) + (this.countryCode == null ? 43 : this.countryCode.hashCode());
        result = (result * PRIME) + (this.phoneNumber == null ? 43 : this.phoneNumber.hashCode());
        result =
                (result * PRIME)
                        + (this.isAccRecEnabled == null ? 43 : this.isAccRecEnabled.hashCode());
        result = (result * PRIME) + (this.deviceUUID == null ? 43 : this.deviceUUID.hashCode());
        result =
                (result * PRIME)
                        + (this.basePublicKey == null ? 43 : this.basePublicKey.hashCode());
        result =
                (result * PRIME)
                        + (this.authenticationMethod == null
                                ? 43
                                : this.authenticationMethod.hashCode());
        result = (result * PRIME) + (this.expiresOn == null ? 43 : this.expiresOn.hashCode());
        result = (result * PRIME) + (this.seedDekId == null ? 43 : this.seedDekId.hashCode());
        result = (result * PRIME) + (this.seed == null ? 43 : this.seed.hashCode());
        result =
                (result * PRIME)
                        + (this.thirdPartyFactor == null ? 43 : this.thirdPartyFactor.hashCode());
        result = (result * PRIME) + (this.user == null ? 43 : this.user.hashCode());
        result =
                (result * PRIME)
                        + (this.pushNotificationTarget == null
                                ? 43
                                : this.pushNotificationTarget.hashCode());
        result =
                (result * PRIME)
                        + (this.additionalAttributes == null
                                ? 43
                                : this.additionalAttributes.hashCode());
        result =
                (result * PRIME)
                        + (this.authenticationFactors == null
                                ? 43
                                : this.authenticationFactors.hashCode());
        result =
                (result * PRIME)
                        + (this.nonCompliances == null ? 43 : this.nonCompliances.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
