/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.osmanagementhub.model;

/**
 * Provides additional information about the Ksplice known exploit detection. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220901")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = ExploitAttemptAdditionalDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ExploitAttemptAdditionalDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"exploitCves"})
    public ExploitAttemptAdditionalDetails(java.util.List<String> exploitCves) {
        super();
        this.exploitCves = exploitCves;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** List of CVEs in the exploit. */
        @com.fasterxml.jackson.annotation.JsonProperty("exploitCves")
        private java.util.List<String> exploitCves;

        /**
         * List of CVEs in the exploit.
         *
         * @param exploitCves the value to set
         * @return this builder
         */
        public Builder exploitCves(java.util.List<String> exploitCves) {
            this.exploitCves = exploitCves;
            this.__explicitlySet__.add("exploitCves");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ExploitAttemptAdditionalDetails build() {
            ExploitAttemptAdditionalDetails model =
                    new ExploitAttemptAdditionalDetails(this.exploitCves);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ExploitAttemptAdditionalDetails model) {
            if (model.wasPropertyExplicitlySet("exploitCves")) {
                this.exploitCves(model.getExploitCves());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** List of CVEs in the exploit. */
    @com.fasterxml.jackson.annotation.JsonProperty("exploitCves")
    private final java.util.List<String> exploitCves;

    /**
     * List of CVEs in the exploit.
     *
     * @return the value
     */
    public java.util.List<String> getExploitCves() {
        return exploitCves;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ExploitAttemptAdditionalDetails(");
        sb.append("super=").append(super.toString());
        sb.append("exploitCves=").append(String.valueOf(this.exploitCves));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExploitAttemptAdditionalDetails)) {
            return false;
        }

        ExploitAttemptAdditionalDetails other = (ExploitAttemptAdditionalDetails) o;
        return java.util.Objects.equals(this.exploitCves, other.exploitCves) && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.exploitCves == null ? 43 : this.exploitCves.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
