/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.resourcemanager.responses;

import com.oracle.bmc.resourcemanager.model.*;

@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20180917")
public class ListTemplateCategoriesResponse extends com.oracle.bmc.responses.BmcResponse {
    /** Unique identifier for the request. */
    private String opcRequestId;

    /**
     * Unique identifier for the request.
     *
     * @return the value
     */
    public String getOpcRequestId() {
        return opcRequestId;
    }

    /** The returned {@code TemplateCategorySummaryCollection} instance. */
    private com.oracle.bmc.resourcemanager.model.TemplateCategorySummaryCollection
            templateCategorySummaryCollection;

    /**
     * The returned {@code TemplateCategorySummaryCollection} instance.
     *
     * @return the value
     */
    public com.oracle.bmc.resourcemanager.model.TemplateCategorySummaryCollection
            getTemplateCategorySummaryCollection() {
        return templateCategorySummaryCollection;
    }

    @java.beans.ConstructorProperties({
        "__httpStatusCode__",
        "headers",
        "opcRequestId",
        "templateCategorySummaryCollection"
    })
    private ListTemplateCategoriesResponse(
            int __httpStatusCode__,
            java.util.Map<String, java.util.List<String>> headers,
            String opcRequestId,
            com.oracle.bmc.resourcemanager.model.TemplateCategorySummaryCollection
                    templateCategorySummaryCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.templateCategorySummaryCollection = templateCategorySummaryCollection;
    }

    public static class Builder
            implements com.oracle.bmc.responses.BmcResponse.Builder<
                    ListTemplateCategoriesResponse> {
        private int __httpStatusCode__;

        @Override
        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        private java.util.Map<String, java.util.List<String>> headers;

        @Override
        public Builder headers(java.util.Map<String, java.util.List<String>> headers) {
            this.headers = headers;
            return this;
        }

        /** Unique identifier for the request. */
        private String opcRequestId;

        /**
         * Unique identifier for the request.
         *
         * @param opcRequestId the value to set
         * @return this builder
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /** The returned {@code TemplateCategorySummaryCollection} instance. */
        private com.oracle.bmc.resourcemanager.model.TemplateCategorySummaryCollection
                templateCategorySummaryCollection;

        /**
         * The returned {@code TemplateCategorySummaryCollection} instance.
         *
         * @param templateCategorySummaryCollection the value to set
         * @return this builder
         */
        public Builder templateCategorySummaryCollection(
                com.oracle.bmc.resourcemanager.model.TemplateCategorySummaryCollection
                        templateCategorySummaryCollection) {
            this.templateCategorySummaryCollection = templateCategorySummaryCollection;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        @Override
        public Builder copy(ListTemplateCategoriesResponse o) {
            __httpStatusCode__(o.get__httpStatusCode__());
            headers(o.getHeaders());
            opcRequestId(o.getOpcRequestId());
            templateCategorySummaryCollection(o.getTemplateCategorySummaryCollection());

            return this;
        }

        /**
         * Build the response object.
         *
         * @return the response object
         */
        @Override
        public ListTemplateCategoriesResponse build() {
            return new ListTemplateCategoriesResponse(
                    __httpStatusCode__, headers, opcRequestId, templateCategorySummaryCollection);
        }
    }

    /**
     * Return a new builder for this response object.
     *
     * @return builder for the response object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(opcRequestId));
        sb.append(",templateCategorySummaryCollection=")
                .append(String.valueOf(templateCategorySummaryCollection));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTemplateCategoriesResponse)) {
            return false;
        }

        ListTemplateCategoriesResponse other = (ListTemplateCategoriesResponse) o;
        return super.equals(o)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId)
                && java.util.Objects.equals(
                        this.templateCategorySummaryCollection,
                        other.templateCategorySummaryCollection);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result =
                (result * PRIME)
                        + (this.templateCategorySummaryCollection == null
                                ? 43
                                : this.templateCategorySummaryCollection.hashCode());
        return result;
    }
}
